/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.OperatingSystem;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPatchBaselineForPatchGroupResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, GetPatchBaselineForPatchGroupResponse> {
    private static final SdkField<String> BASELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaselineId").getter(GetPatchBaselineForPatchGroupResponse.getter(GetPatchBaselineForPatchGroupResponse::baselineId)).setter(GetPatchBaselineForPatchGroupResponse.setter(Builder::baselineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineId").build()}).build();
    private static final SdkField<String> PATCH_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PatchGroup").getter(GetPatchBaselineForPatchGroupResponse.getter(GetPatchBaselineForPatchGroupResponse::patchGroup)).setter(GetPatchBaselineForPatchGroupResponse.setter(Builder::patchGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchGroup").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystem").getter(GetPatchBaselineForPatchGroupResponse.getter(GetPatchBaselineForPatchGroupResponse::operatingSystemAsString)).setter(GetPatchBaselineForPatchGroupResponse.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_ID_FIELD, PATCH_GROUP_FIELD, OPERATING_SYSTEM_FIELD));
    private final String baselineId;
    private final String patchGroup;
    private final String operatingSystem;

    private GetPatchBaselineForPatchGroupResponse(BuilderImpl builder) {
        super(builder);
        this.baselineId = builder.baselineId;
        this.patchGroup = builder.patchGroup;
        this.operatingSystem = builder.operatingSystem;
    }

    public final String baselineId() {
        return this.baselineId;
    }

    public final String patchGroup() {
        return this.patchGroup;
    }

    public final OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public final String operatingSystemAsString() {
        return this.operatingSystem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPatchBaselineForPatchGroupResponse)) {
            return false;
        }
        GetPatchBaselineForPatchGroupResponse other = (GetPatchBaselineForPatchGroupResponse)((Object)obj);
        return Objects.equals(this.baselineId(), other.baselineId()) && Objects.equals(this.patchGroup(), other.patchGroup()) && Objects.equals(this.operatingSystemAsString(), other.operatingSystemAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetPatchBaselineForPatchGroupResponse").add("BaselineId", (Object)this.baselineId()).add("PatchGroup", (Object)this.patchGroup()).add("OperatingSystem", (Object)this.operatingSystemAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaselineId": {
                return Optional.ofNullable(clazz.cast(this.baselineId()));
            }
            case "PatchGroup": {
                return Optional.ofNullable(clazz.cast(this.patchGroup()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPatchBaselineForPatchGroupResponse, T> g) {
        return obj -> g.apply((GetPatchBaselineForPatchGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String baselineId;
        private String patchGroup;
        private String operatingSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPatchBaselineForPatchGroupResponse model) {
            super(model);
            this.baselineId(model.baselineId);
            this.patchGroup(model.patchGroup);
            this.operatingSystem(model.operatingSystem);
        }

        public final String getBaselineId() {
            return this.baselineId;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        @Override
        @Transient
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final String getPatchGroup() {
            return this.patchGroup;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        @Override
        @Transient
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        @Transient
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        @Transient
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        @Override
        public GetPatchBaselineForPatchGroupResponse build() {
            return new GetPatchBaselineForPatchGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPatchBaselineForPatchGroupResponse> {
        public Builder baselineId(String var1);

        public Builder patchGroup(String var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);
    }
}

