/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum OpsItemFilterKey {
    STATUS("Status"),

    CREATED_BY("CreatedBy"),

    SOURCE("Source"),

    PRIORITY("Priority"),

    TITLE("Title"),

    OPS_ITEM_ID("OpsItemId"),

    CREATED_TIME("CreatedTime"),

    LAST_MODIFIED_TIME("LastModifiedTime"),

    ACTUAL_START_TIME("ActualStartTime"),

    ACTUAL_END_TIME("ActualEndTime"),

    PLANNED_START_TIME("PlannedStartTime"),

    PLANNED_END_TIME("PlannedEndTime"),

    OPERATIONAL_DATA("OperationalData"),

    OPERATIONAL_DATA_KEY("OperationalDataKey"),

    OPERATIONAL_DATA_VALUE("OperationalDataValue"),

    RESOURCE_ID("ResourceId"),

    AUTOMATION_ID("AutomationId"),

    CATEGORY("Category"),

    SEVERITY("Severity"),

    OPS_ITEM_TYPE("OpsItemType"),

    CHANGE_REQUEST_BY_REQUESTER_ARN("ChangeRequestByRequesterArn"),

    CHANGE_REQUEST_BY_REQUESTER_NAME("ChangeRequestByRequesterName"),

    CHANGE_REQUEST_BY_APPROVER_ARN("ChangeRequestByApproverArn"),

    CHANGE_REQUEST_BY_APPROVER_NAME("ChangeRequestByApproverName"),

    CHANGE_REQUEST_BY_TEMPLATE("ChangeRequestByTemplate"),

    CHANGE_REQUEST_BY_TARGETS_RESOURCE_GROUP("ChangeRequestByTargetsResourceGroup"),

    INSIGHT_BY_TYPE("InsightByType"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OpsItemFilterKey> VALUE_MAP = EnumUtils.uniqueIndex(OpsItemFilterKey.class,
            OpsItemFilterKey::toString);

    private final String value;

    private OpsItemFilterKey(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return OpsItemFilterKey corresponding to the value
     */
    public static OpsItemFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link OpsItemFilterKey}s
     */
    public static Set<OpsItemFilterKey> knownValues() {
        Set<OpsItemFilterKey> knownValues = EnumSet.allOf(OpsItemFilterKey.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
