/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status information about the instance association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceAssociationStatusInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceAssociationStatusInfo.Builder, InstanceAssociationStatusInfo> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationId").getter(getter(InstanceAssociationStatusInfo::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(InstanceAssociationStatusInfo::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentVersion").getter(getter(InstanceAssociationStatusInfo::documentVersion))
            .setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final SdkField<String> ASSOCIATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationVersion").getter(getter(InstanceAssociationStatusInfo::associationVersion))
            .setter(setter(Builder::associationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationVersion").build())
            .build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(InstanceAssociationStatusInfo::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<Instant> EXECUTION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExecutionDate").getter(getter(InstanceAssociationStatusInfo::executionDate))
            .setter(setter(Builder::executionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionDate").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(InstanceAssociationStatusInfo::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> DETAILED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailedStatus").getter(getter(InstanceAssociationStatusInfo::detailedStatus))
            .setter(setter(Builder::detailedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatus").build()).build();

    private static final SdkField<String> EXECUTION_SUMMARY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionSummary").getter(getter(InstanceAssociationStatusInfo::executionSummary))
            .setter(setter(Builder::executionSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionSummary").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(InstanceAssociationStatusInfo::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<InstanceAssociationOutputUrl> OUTPUT_URL_FIELD = SdkField
            .<InstanceAssociationOutputUrl> builder(MarshallingType.SDK_POJO).memberName("OutputUrl")
            .getter(getter(InstanceAssociationStatusInfo::outputUrl)).setter(setter(Builder::outputUrl))
            .constructor(InstanceAssociationOutputUrl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputUrl").build()).build();

    private static final SdkField<String> ASSOCIATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationName").getter(getter(InstanceAssociationStatusInfo::associationName))
            .setter(setter(Builder::associationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD,
            NAME_FIELD, DOCUMENT_VERSION_FIELD, ASSOCIATION_VERSION_FIELD, INSTANCE_ID_FIELD, EXECUTION_DATE_FIELD, STATUS_FIELD,
            DETAILED_STATUS_FIELD, EXECUTION_SUMMARY_FIELD, ERROR_CODE_FIELD, OUTPUT_URL_FIELD, ASSOCIATION_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String associationId;

    private final String name;

    private final String documentVersion;

    private final String associationVersion;

    private final String instanceId;

    private final Instant executionDate;

    private final String status;

    private final String detailedStatus;

    private final String executionSummary;

    private final String errorCode;

    private final InstanceAssociationOutputUrl outputUrl;

    private final String associationName;

    private InstanceAssociationStatusInfo(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
        this.associationVersion = builder.associationVersion;
        this.instanceId = builder.instanceId;
        this.executionDate = builder.executionDate;
        this.status = builder.status;
        this.detailedStatus = builder.detailedStatus;
        this.executionSummary = builder.executionSummary;
        this.errorCode = builder.errorCode;
        this.outputUrl = builder.outputUrl;
        this.associationName = builder.associationName;
    }

    /**
     * <p>
     * The association ID.
     * </p>
     * 
     * @return The association ID.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The name of the association.
     * </p>
     * 
     * @return The name of the association.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The association document versions.
     * </p>
     * 
     * @return The association document versions.
     */
    public final String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The version of the association applied to the instance.
     * </p>
     * 
     * @return The version of the association applied to the instance.
     */
    public final String associationVersion() {
        return associationVersion;
    }

    /**
     * <p>
     * The instance ID where the association was created.
     * </p>
     * 
     * @return The instance ID where the association was created.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The date the instance association ran.
     * </p>
     * 
     * @return The date the instance association ran.
     */
    public final Instant executionDate() {
        return executionDate;
    }

    /**
     * <p>
     * Status information about the instance association.
     * </p>
     * 
     * @return Status information about the instance association.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Detailed status information about the instance association.
     * </p>
     * 
     * @return Detailed status information about the instance association.
     */
    public final String detailedStatus() {
        return detailedStatus;
    }

    /**
     * <p>
     * Summary information about association execution.
     * </p>
     * 
     * @return Summary information about association execution.
     */
    public final String executionSummary() {
        return executionSummary;
    }

    /**
     * <p>
     * An error code returned by the request to create the association.
     * </p>
     * 
     * @return An error code returned by the request to create the association.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * A URL for an S3 bucket where you want to store the results of this request.
     * </p>
     * 
     * @return A URL for an S3 bucket where you want to store the results of this request.
     */
    public final InstanceAssociationOutputUrl outputUrl() {
        return outputUrl;
    }

    /**
     * <p>
     * The name of the association applied to the instance.
     * </p>
     * 
     * @return The name of the association applied to the instance.
     */
    public final String associationName() {
        return associationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(associationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(executionDate());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(detailedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(executionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(outputUrl());
        hashCode = 31 * hashCode + Objects.hashCode(associationName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAssociationStatusInfo)) {
            return false;
        }
        InstanceAssociationStatusInfo other = (InstanceAssociationStatusInfo) obj;
        return Objects.equals(associationId(), other.associationId()) && Objects.equals(name(), other.name())
                && Objects.equals(documentVersion(), other.documentVersion())
                && Objects.equals(associationVersion(), other.associationVersion())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(executionDate(), other.executionDate())
                && Objects.equals(status(), other.status()) && Objects.equals(detailedStatus(), other.detailedStatus())
                && Objects.equals(executionSummary(), other.executionSummary()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(outputUrl(), other.outputUrl()) && Objects.equals(associationName(), other.associationName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceAssociationStatusInfo").add("AssociationId", associationId()).add("Name", name())
                .add("DocumentVersion", documentVersion()).add("AssociationVersion", associationVersion())
                .add("InstanceId", instanceId()).add("ExecutionDate", executionDate()).add("Status", status())
                .add("DetailedStatus", detailedStatus()).add("ExecutionSummary", executionSummary())
                .add("ErrorCode", errorCode()).add("OutputUrl", outputUrl()).add("AssociationName", associationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "AssociationVersion":
            return Optional.ofNullable(clazz.cast(associationVersion()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ExecutionDate":
            return Optional.ofNullable(clazz.cast(executionDate()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "DetailedStatus":
            return Optional.ofNullable(clazz.cast(detailedStatus()));
        case "ExecutionSummary":
            return Optional.ofNullable(clazz.cast(executionSummary()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "OutputUrl":
            return Optional.ofNullable(clazz.cast(outputUrl()));
        case "AssociationName":
            return Optional.ofNullable(clazz.cast(associationName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceAssociationStatusInfo, T> g) {
        return obj -> g.apply((InstanceAssociationStatusInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceAssociationStatusInfo> {
        /**
         * <p>
         * The association ID.
         * </p>
         * 
         * @param associationId
         *        The association ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The name of the association.
         * </p>
         * 
         * @param name
         *        The name of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The association document versions.
         * </p>
         * 
         * @param documentVersion
         *        The association document versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The version of the association applied to the instance.
         * </p>
         * 
         * @param associationVersion
         *        The version of the association applied to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationVersion(String associationVersion);

        /**
         * <p>
         * The instance ID where the association was created.
         * </p>
         * 
         * @param instanceId
         *        The instance ID where the association was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The date the instance association ran.
         * </p>
         * 
         * @param executionDate
         *        The date the instance association ran.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionDate(Instant executionDate);

        /**
         * <p>
         * Status information about the instance association.
         * </p>
         * 
         * @param status
         *        Status information about the instance association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Detailed status information about the instance association.
         * </p>
         * 
         * @param detailedStatus
         *        Detailed status information about the instance association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailedStatus(String detailedStatus);

        /**
         * <p>
         * Summary information about association execution.
         * </p>
         * 
         * @param executionSummary
         *        Summary information about association execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionSummary(String executionSummary);

        /**
         * <p>
         * An error code returned by the request to create the association.
         * </p>
         * 
         * @param errorCode
         *        An error code returned by the request to create the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * A URL for an S3 bucket where you want to store the results of this request.
         * </p>
         * 
         * @param outputUrl
         *        A URL for an S3 bucket where you want to store the results of this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputUrl(InstanceAssociationOutputUrl outputUrl);

        /**
         * <p>
         * A URL for an S3 bucket where you want to store the results of this request.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceAssociationOutputUrl.Builder} avoiding
         * the need to create one manually via {@link InstanceAssociationOutputUrl#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceAssociationOutputUrl.Builder#build()} is called
         * immediately and its result is passed to {@link #outputUrl(InstanceAssociationOutputUrl)}.
         * 
         * @param outputUrl
         *        a consumer that will call methods on {@link InstanceAssociationOutputUrl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputUrl(InstanceAssociationOutputUrl)
         */
        default Builder outputUrl(Consumer<InstanceAssociationOutputUrl.Builder> outputUrl) {
            return outputUrl(InstanceAssociationOutputUrl.builder().applyMutation(outputUrl).build());
        }

        /**
         * <p>
         * The name of the association applied to the instance.
         * </p>
         * 
         * @param associationName
         *        The name of the association applied to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationName(String associationName);
    }

    static final class BuilderImpl implements Builder {
        private String associationId;

        private String name;

        private String documentVersion;

        private String associationVersion;

        private String instanceId;

        private Instant executionDate;

        private String status;

        private String detailedStatus;

        private String executionSummary;

        private String errorCode;

        private InstanceAssociationOutputUrl outputUrl;

        private String associationName;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAssociationStatusInfo model) {
            associationId(model.associationId);
            name(model.name);
            documentVersion(model.documentVersion);
            associationVersion(model.associationVersion);
            instanceId(model.instanceId);
            executionDate(model.executionDate);
            status(model.status);
            detailedStatus(model.detailedStatus);
            executionSummary(model.executionSummary);
            errorCode(model.errorCode);
            outputUrl(model.outputUrl);
            associationName(model.associationName);
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        @Transient
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        @Transient
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final String getAssociationVersion() {
            return associationVersion;
        }

        public final void setAssociationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
        }

        @Override
        @Transient
        public final Builder associationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Instant getExecutionDate() {
            return executionDate;
        }

        public final void setExecutionDate(Instant executionDate) {
            this.executionDate = executionDate;
        }

        @Override
        @Transient
        public final Builder executionDate(Instant executionDate) {
            this.executionDate = executionDate;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getDetailedStatus() {
            return detailedStatus;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        @Override
        @Transient
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final String getExecutionSummary() {
            return executionSummary;
        }

        public final void setExecutionSummary(String executionSummary) {
            this.executionSummary = executionSummary;
        }

        @Override
        @Transient
        public final Builder executionSummary(String executionSummary) {
            this.executionSummary = executionSummary;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        @Transient
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final InstanceAssociationOutputUrl.Builder getOutputUrl() {
            return outputUrl != null ? outputUrl.toBuilder() : null;
        }

        public final void setOutputUrl(InstanceAssociationOutputUrl.BuilderImpl outputUrl) {
            this.outputUrl = outputUrl != null ? outputUrl.build() : null;
        }

        @Override
        @Transient
        public final Builder outputUrl(InstanceAssociationOutputUrl outputUrl) {
            this.outputUrl = outputUrl;
            return this;
        }

        public final String getAssociationName() {
            return associationName;
        }

        public final void setAssociationName(String associationName) {
            this.associationName = associationName;
        }

        @Override
        @Transient
        public final Builder associationName(String associationName) {
            this.associationName = associationName;
            return this;
        }

        @Override
        public InstanceAssociationStatusInfo build() {
            return new InstanceAssociationStatusInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
