/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.OpsItemIdentity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpsItemRelatedItemSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpsItemRelatedItemSummary> {
    private static final SdkField<String> OPS_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpsItemId").getter(OpsItemRelatedItemSummary.getter(OpsItemRelatedItemSummary::opsItemId)).setter(OpsItemRelatedItemSummary.setter(Builder::opsItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemId").build()}).build();
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(OpsItemRelatedItemSummary.getter(OpsItemRelatedItemSummary::associationId)).setter(OpsItemRelatedItemSummary.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(OpsItemRelatedItemSummary.getter(OpsItemRelatedItemSummary::resourceType)).setter(OpsItemRelatedItemSummary.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationType").getter(OpsItemRelatedItemSummary.getter(OpsItemRelatedItemSummary::associationType)).setter(OpsItemRelatedItemSummary.setter(Builder::associationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationType").build()}).build();
    private static final SdkField<String> RESOURCE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceUri").getter(OpsItemRelatedItemSummary.getter(OpsItemRelatedItemSummary::resourceUri)).setter(OpsItemRelatedItemSummary.setter(Builder::resourceUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceUri").build()}).build();
    private static final SdkField<OpsItemIdentity> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(OpsItemRelatedItemSummary.getter(OpsItemRelatedItemSummary::createdBy)).setter(OpsItemRelatedItemSummary.setter(Builder::createdBy)).constructor(OpsItemIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(OpsItemRelatedItemSummary.getter(OpsItemRelatedItemSummary::createdTime)).setter(OpsItemRelatedItemSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<OpsItemIdentity> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedBy").getter(OpsItemRelatedItemSummary.getter(OpsItemRelatedItemSummary::lastModifiedBy)).setter(OpsItemRelatedItemSummary.setter(Builder::lastModifiedBy)).constructor(OpsItemIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(OpsItemRelatedItemSummary.getter(OpsItemRelatedItemSummary::lastModifiedTime)).setter(OpsItemRelatedItemSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_ITEM_ID_FIELD, ASSOCIATION_ID_FIELD, RESOURCE_TYPE_FIELD, ASSOCIATION_TYPE_FIELD, RESOURCE_URI_FIELD, CREATED_BY_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String opsItemId;
    private final String associationId;
    private final String resourceType;
    private final String associationType;
    private final String resourceUri;
    private final OpsItemIdentity createdBy;
    private final Instant createdTime;
    private final OpsItemIdentity lastModifiedBy;
    private final Instant lastModifiedTime;

    private OpsItemRelatedItemSummary(BuilderImpl builder) {
        this.opsItemId = builder.opsItemId;
        this.associationId = builder.associationId;
        this.resourceType = builder.resourceType;
        this.associationType = builder.associationType;
        this.resourceUri = builder.resourceUri;
        this.createdBy = builder.createdBy;
        this.createdTime = builder.createdTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String opsItemId() {
        return this.opsItemId;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String associationType() {
        return this.associationType;
    }

    public final String resourceUri() {
        return this.resourceUri;
    }

    public final OpsItemIdentity createdBy() {
        return this.createdBy;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final OpsItemIdentity lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.opsItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpsItemRelatedItemSummary)) {
            return false;
        }
        OpsItemRelatedItemSummary other = (OpsItemRelatedItemSummary)obj;
        return Objects.equals(this.opsItemId(), other.opsItemId()) && Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.associationType(), other.associationType()) && Objects.equals(this.resourceUri(), other.resourceUri()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"OpsItemRelatedItemSummary").add("OpsItemId", (Object)this.opsItemId()).add("AssociationId", (Object)this.associationId()).add("ResourceType", (Object)this.resourceType()).add("AssociationType", (Object)this.associationType()).add("ResourceUri", (Object)this.resourceUri()).add("CreatedBy", (Object)this.createdBy()).add("CreatedTime", (Object)this.createdTime()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OpsItemId": {
                return Optional.ofNullable(clazz.cast(this.opsItemId()));
            }
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "AssociationType": {
                return Optional.ofNullable(clazz.cast(this.associationType()));
            }
            case "ResourceUri": {
                return Optional.ofNullable(clazz.cast(this.resourceUri()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpsItemRelatedItemSummary, T> g) {
        return obj -> g.apply((OpsItemRelatedItemSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String opsItemId;
        private String associationId;
        private String resourceType;
        private String associationType;
        private String resourceUri;
        private OpsItemIdentity createdBy;
        private Instant createdTime;
        private OpsItemIdentity lastModifiedBy;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OpsItemRelatedItemSummary model) {
            this.opsItemId(model.opsItemId);
            this.associationId(model.associationId);
            this.resourceType(model.resourceType);
            this.associationType(model.associationType);
            this.resourceUri(model.resourceUri);
            this.createdBy(model.createdBy);
            this.createdTime(model.createdTime);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getOpsItemId() {
            return this.opsItemId;
        }

        public final void setOpsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
        }

        @Override
        public final Builder opsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
            return this;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getAssociationType() {
            return this.associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        public final String getResourceUri() {
            return this.resourceUri;
        }

        public final void setResourceUri(String resourceUri) {
            this.resourceUri = resourceUri;
        }

        @Override
        public final Builder resourceUri(String resourceUri) {
            this.resourceUri = resourceUri;
            return this;
        }

        public final OpsItemIdentity.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(OpsItemIdentity.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(OpsItemIdentity createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final OpsItemIdentity.Builder getLastModifiedBy() {
            return this.lastModifiedBy != null ? this.lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(OpsItemIdentity.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(OpsItemIdentity lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public OpsItemRelatedItemSummary build() {
            return new OpsItemRelatedItemSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpsItemRelatedItemSummary> {
        public Builder opsItemId(String var1);

        public Builder associationId(String var1);

        public Builder resourceType(String var1);

        public Builder associationType(String var1);

        public Builder resourceUri(String var1);

        public Builder createdBy(OpsItemIdentity var1);

        default public Builder createdBy(Consumer<OpsItemIdentity.Builder> createdBy) {
            return this.createdBy((OpsItemIdentity)((OpsItemIdentity.Builder)OpsItemIdentity.builder().applyMutation(createdBy)).build());
        }

        public Builder createdTime(Instant var1);

        public Builder lastModifiedBy(OpsItemIdentity var1);

        default public Builder lastModifiedBy(Consumer<OpsItemIdentity.Builder> lastModifiedBy) {
            return this.lastModifiedBy((OpsItemIdentity)((OpsItemIdentity.Builder)OpsItemIdentity.builder().applyMutation(lastModifiedBy)).build());
        }

        public Builder lastModifiedTime(Instant var1);
    }
}

