/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about targets that resolved during the Automation execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolvedTargets implements SdkPojo, Serializable, ToCopyableBuilder<ResolvedTargets.Builder, ResolvedTargets> {
    private static final SdkField<List<String>> PARAMETER_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ParameterValues")
            .getter(getter(ResolvedTargets::parameterValues))
            .setter(setter(Builder::parameterValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> TRUNCATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Truncated").getter(getter(ResolvedTargets::truncated)).setter(setter(Builder::truncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Truncated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_VALUES_FIELD,
            TRUNCATED_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> parameterValues;

    private final Boolean truncated;

    private ResolvedTargets(BuilderImpl builder) {
        this.parameterValues = builder.parameterValues;
        this.truncated = builder.truncated;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParameterValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParameterValues() {
        return parameterValues != null && !(parameterValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of parameter values sent to targets that resolved during the Automation execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameterValues} method.
     * </p>
     * 
     * @return A list of parameter values sent to targets that resolved during the Automation execution.
     */
    public final List<String> parameterValues() {
        return parameterValues;
    }

    /**
     * <p>
     * A boolean value indicating whether the resolved target list is truncated.
     * </p>
     * 
     * @return A boolean value indicating whether the resolved target list is truncated.
     */
    public final Boolean truncated() {
        return truncated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterValues() ? parameterValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(truncated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolvedTargets)) {
            return false;
        }
        ResolvedTargets other = (ResolvedTargets) obj;
        return hasParameterValues() == other.hasParameterValues() && Objects.equals(parameterValues(), other.parameterValues())
                && Objects.equals(truncated(), other.truncated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResolvedTargets").add("ParameterValues", hasParameterValues() ? parameterValues() : null)
                .add("Truncated", truncated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterValues":
            return Optional.ofNullable(clazz.cast(parameterValues()));
        case "Truncated":
            return Optional.ofNullable(clazz.cast(truncated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolvedTargets, T> g) {
        return obj -> g.apply((ResolvedTargets) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResolvedTargets> {
        /**
         * <p>
         * A list of parameter values sent to targets that resolved during the Automation execution.
         * </p>
         * 
         * @param parameterValues
         *        A list of parameter values sent to targets that resolved during the Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValues(Collection<String> parameterValues);

        /**
         * <p>
         * A list of parameter values sent to targets that resolved during the Automation execution.
         * </p>
         * 
         * @param parameterValues
         *        A list of parameter values sent to targets that resolved during the Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValues(String... parameterValues);

        /**
         * <p>
         * A boolean value indicating whether the resolved target list is truncated.
         * </p>
         * 
         * @param truncated
         *        A boolean value indicating whether the resolved target list is truncated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truncated(Boolean truncated);
    }

    static final class BuilderImpl implements Builder {
        private List<String> parameterValues = DefaultSdkAutoConstructList.getInstance();

        private Boolean truncated;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolvedTargets model) {
            parameterValues(model.parameterValues);
            truncated(model.truncated);
        }

        public final Collection<String> getParameterValues() {
            if (parameterValues instanceof SdkAutoConstructList) {
                return null;
            }
            return parameterValues;
        }

        public final void setParameterValues(Collection<String> parameterValues) {
            this.parameterValues = TargetParameterListCopier.copy(parameterValues);
        }

        @Override
        @Transient
        public final Builder parameterValues(Collection<String> parameterValues) {
            this.parameterValues = TargetParameterListCopier.copy(parameterValues);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parameterValues(String... parameterValues) {
            parameterValues(Arrays.asList(parameterValues));
            return this;
        }

        public final Boolean getTruncated() {
            return truncated;
        }

        public final void setTruncated(Boolean truncated) {
            this.truncated = truncated;
        }

        @Override
        @Transient
        public final Builder truncated(Boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        @Override
        public ResolvedTargets build() {
            return new ResolvedTargets(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
