/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Synchronize Amazon Web Services Systems Manager Inventory data from multiple accounts defined in Organizations to a
 * centralized Amazon S3 bucket. Data is synchronized to individual key prefixes in the central bucket. Each key prefix
 * represents a different account ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceDataSyncDestinationDataSharing implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceDataSyncDestinationDataSharing.Builder, ResourceDataSyncDestinationDataSharing> {
    private static final SdkField<String> DESTINATION_DATA_SHARING_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationDataSharingType")
            .getter(getter(ResourceDataSyncDestinationDataSharing::destinationDataSharingType))
            .setter(setter(Builder::destinationDataSharingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationDataSharingType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DESTINATION_DATA_SHARING_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationDataSharingType;

    private ResourceDataSyncDestinationDataSharing(BuilderImpl builder) {
        this.destinationDataSharingType = builder.destinationDataSharingType;
    }

    /**
     * <p>
     * The sharing data type. Only <code>Organization</code> is supported.
     * </p>
     * 
     * @return The sharing data type. Only <code>Organization</code> is supported.
     */
    public final String destinationDataSharingType() {
        return destinationDataSharingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationDataSharingType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDataSyncDestinationDataSharing)) {
            return false;
        }
        ResourceDataSyncDestinationDataSharing other = (ResourceDataSyncDestinationDataSharing) obj;
        return Objects.equals(destinationDataSharingType(), other.destinationDataSharingType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceDataSyncDestinationDataSharing")
                .add("DestinationDataSharingType", destinationDataSharingType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationDataSharingType":
            return Optional.ofNullable(clazz.cast(destinationDataSharingType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDataSyncDestinationDataSharing, T> g) {
        return obj -> g.apply((ResourceDataSyncDestinationDataSharing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceDataSyncDestinationDataSharing> {
        /**
         * <p>
         * The sharing data type. Only <code>Organization</code> is supported.
         * </p>
         * 
         * @param destinationDataSharingType
         *        The sharing data type. Only <code>Organization</code> is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationDataSharingType(String destinationDataSharingType);
    }

    static final class BuilderImpl implements Builder {
        private String destinationDataSharingType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDataSyncDestinationDataSharing model) {
            destinationDataSharingType(model.destinationDataSharingType);
        }

        public final String getDestinationDataSharingType() {
            return destinationDataSharingType;
        }

        public final void setDestinationDataSharingType(String destinationDataSharingType) {
            this.destinationDataSharingType = destinationDataSharingType;
        }

        @Override
        @Transient
        public final Builder destinationDataSharingType(String destinationDataSharingType) {
            this.destinationDataSharingType = destinationDataSharingType;
            return this;
        }

        @Override
        public ResourceDataSyncDestinationDataSharing build() {
            return new ResourceDataSyncDestinationDataSharing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
