/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutComplianceItemsRequest extends SsmRequest implements
        ToCopyableBuilder<PutComplianceItemsRequest.Builder, PutComplianceItemsRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(PutComplianceItemsRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(PutComplianceItemsRequest::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplianceType").getter(getter(PutComplianceItemsRequest::complianceType))
            .setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()).build();

    private static final SdkField<ComplianceExecutionSummary> EXECUTION_SUMMARY_FIELD = SdkField
            .<ComplianceExecutionSummary> builder(MarshallingType.SDK_POJO).memberName("ExecutionSummary")
            .getter(getter(PutComplianceItemsRequest::executionSummary)).setter(setter(Builder::executionSummary))
            .constructor(ComplianceExecutionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionSummary").build()).build();

    private static final SdkField<List<ComplianceItemEntry>> ITEMS_FIELD = SdkField
            .<List<ComplianceItemEntry>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(PutComplianceItemsRequest::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComplianceItemEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComplianceItemEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ITEM_CONTENT_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ItemContentHash").getter(getter(PutComplianceItemsRequest::itemContentHash))
            .setter(setter(Builder::itemContentHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemContentHash").build()).build();

    private static final SdkField<String> UPLOAD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UploadType").getter(getter(PutComplianceItemsRequest::uploadTypeAsString))
            .setter(setter(Builder::uploadType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            RESOURCE_TYPE_FIELD, COMPLIANCE_TYPE_FIELD, EXECUTION_SUMMARY_FIELD, ITEMS_FIELD, ITEM_CONTENT_HASH_FIELD,
            UPLOAD_TYPE_FIELD));

    private final String resourceId;

    private final String resourceType;

    private final String complianceType;

    private final ComplianceExecutionSummary executionSummary;

    private final List<ComplianceItemEntry> items;

    private final String itemContentHash;

    private final String uploadType;

    private PutComplianceItemsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.complianceType = builder.complianceType;
        this.executionSummary = builder.executionSummary;
        this.items = builder.items;
        this.itemContentHash = builder.itemContentHash;
        this.uploadType = builder.uploadType;
    }

    /**
     * <p>
     * Specify an ID for this resource. For a managed instance, this is the instance ID.
     * </p>
     * 
     * @return Specify an ID for this resource. For a managed instance, this is the instance ID.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Specify the type of resource. <code>ManagedInstance</code> is currently the only supported resource type.
     * </p>
     * 
     * @return Specify the type of resource. <code>ManagedInstance</code> is currently the only supported resource type.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Specify the compliance type. For example, specify Association (for a State Manager association), Patch, or
     * Custom:<code>string</code>.
     * </p>
     * 
     * @return Specify the compliance type. For example, specify Association (for a State Manager association), Patch,
     *         or Custom:<code>string</code>.
     */
    public final String complianceType() {
        return complianceType;
    }

    /**
     * <p>
     * A summary of the call execution that includes an execution ID, the type of execution (for example,
     * <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the following
     * format: yyyy-MM-dd'T'HH:mm:ss'Z'.
     * </p>
     * 
     * @return A summary of the call execution that includes an execution ID, the type of execution (for example,
     *         <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the
     *         following format: yyyy-MM-dd'T'HH:mm:ss'Z'.
     */
    public final ComplianceExecutionSummary executionSummary() {
        return executionSummary;
    }

    /**
     * Returns true if the Items property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the compliance as defined by the resource type. For example, for a patch compliance type,
     * <code>Items</code> includes information about the PatchSeverity, Classification, and so on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the compliance as defined by the resource type. For example, for a patch compliance
     *         type, <code>Items</code> includes information about the PatchSeverity, Classification, and so on.
     */
    public final List<ComplianceItemEntry> items() {
        return items;
    }

    /**
     * <p>
     * MD5 or SHA-256 content hash. The content hash is used to determine if existing information should be overwritten
     * or ignored. If the content hashes match, the request to put compliance information is ignored.
     * </p>
     * 
     * @return MD5 or SHA-256 content hash. The content hash is used to determine if existing information should be
     *         overwritten or ignored. If the content hashes match, the request to put compliance information is
     *         ignored.
     */
    public final String itemContentHash() {
        return itemContentHash;
    }

    /**
     * <p>
     * The mode for uploading compliance items. You can specify <code>COMPLETE</code> or <code>PARTIAL</code>. In
     * <code>COMPLETE</code> mode, the system overwrites all existing compliance information for the resource. You must
     * provide a full list of compliance items each time you send the request.
     * </p>
     * <p>
     * In <code>PARTIAL</code> mode, the system overwrites compliance information for a specific association. The
     * association must be configured with <code>SyncCompliance</code> set to <code>MANUAL</code>. By default, all
     * requests use <code>COMPLETE</code> mode.
     * </p>
     * <note>
     * <p>
     * This attribute is only valid for association compliance.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uploadType} will
     * return {@link ComplianceUploadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #uploadTypeAsString}.
     * </p>
     * 
     * @return The mode for uploading compliance items. You can specify <code>COMPLETE</code> or <code>PARTIAL</code>.
     *         In <code>COMPLETE</code> mode, the system overwrites all existing compliance information for the
     *         resource. You must provide a full list of compliance items each time you send the request.</p>
     *         <p>
     *         In <code>PARTIAL</code> mode, the system overwrites compliance information for a specific association.
     *         The association must be configured with <code>SyncCompliance</code> set to <code>MANUAL</code>. By
     *         default, all requests use <code>COMPLETE</code> mode.
     *         </p>
     *         <note>
     *         <p>
     *         This attribute is only valid for association compliance.
     *         </p>
     * @see ComplianceUploadType
     */
    public final ComplianceUploadType uploadType() {
        return ComplianceUploadType.fromValue(uploadType);
    }

    /**
     * <p>
     * The mode for uploading compliance items. You can specify <code>COMPLETE</code> or <code>PARTIAL</code>. In
     * <code>COMPLETE</code> mode, the system overwrites all existing compliance information for the resource. You must
     * provide a full list of compliance items each time you send the request.
     * </p>
     * <p>
     * In <code>PARTIAL</code> mode, the system overwrites compliance information for a specific association. The
     * association must be configured with <code>SyncCompliance</code> set to <code>MANUAL</code>. By default, all
     * requests use <code>COMPLETE</code> mode.
     * </p>
     * <note>
     * <p>
     * This attribute is only valid for association compliance.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uploadType} will
     * return {@link ComplianceUploadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #uploadTypeAsString}.
     * </p>
     * 
     * @return The mode for uploading compliance items. You can specify <code>COMPLETE</code> or <code>PARTIAL</code>.
     *         In <code>COMPLETE</code> mode, the system overwrites all existing compliance information for the
     *         resource. You must provide a full list of compliance items each time you send the request.</p>
     *         <p>
     *         In <code>PARTIAL</code> mode, the system overwrites compliance information for a specific association.
     *         The association must be configured with <code>SyncCompliance</code> set to <code>MANUAL</code>. By
     *         default, all requests use <code>COMPLETE</code> mode.
     *         </p>
     *         <note>
     *         <p>
     *         This attribute is only valid for association compliance.
     *         </p>
     * @see ComplianceUploadType
     */
    public final String uploadTypeAsString() {
        return uploadType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(executionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(itemContentHash());
        hashCode = 31 * hashCode + Objects.hashCode(uploadTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutComplianceItemsRequest)) {
            return false;
        }
        PutComplianceItemsRequest other = (PutComplianceItemsRequest) obj;
        return Objects.equals(resourceId(), other.resourceId()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(complianceType(), other.complianceType())
                && Objects.equals(executionSummary(), other.executionSummary()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items()) && Objects.equals(itemContentHash(), other.itemContentHash())
                && Objects.equals(uploadTypeAsString(), other.uploadTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutComplianceItemsRequest").add("ResourceId", resourceId()).add("ResourceType", resourceType())
                .add("ComplianceType", complianceType()).add("ExecutionSummary", executionSummary())
                .add("Items", hasItems() ? items() : null).add("ItemContentHash", itemContentHash())
                .add("UploadType", uploadTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ComplianceType":
            return Optional.ofNullable(clazz.cast(complianceType()));
        case "ExecutionSummary":
            return Optional.ofNullable(clazz.cast(executionSummary()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "ItemContentHash":
            return Optional.ofNullable(clazz.cast(itemContentHash()));
        case "UploadType":
            return Optional.ofNullable(clazz.cast(uploadTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutComplianceItemsRequest, T> g) {
        return obj -> g.apply((PutComplianceItemsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutComplianceItemsRequest> {
        /**
         * <p>
         * Specify an ID for this resource. For a managed instance, this is the instance ID.
         * </p>
         * 
         * @param resourceId
         *        Specify an ID for this resource. For a managed instance, this is the instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Specify the type of resource. <code>ManagedInstance</code> is currently the only supported resource type.
         * </p>
         * 
         * @param resourceType
         *        Specify the type of resource. <code>ManagedInstance</code> is currently the only supported resource
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Specify the compliance type. For example, specify Association (for a State Manager association), Patch, or
         * Custom:<code>string</code>.
         * </p>
         * 
         * @param complianceType
         *        Specify the compliance type. For example, specify Association (for a State Manager association),
         *        Patch, or Custom:<code>string</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * A summary of the call execution that includes an execution ID, the type of execution (for example,
         * <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the
         * following format: yyyy-MM-dd'T'HH:mm:ss'Z'.
         * </p>
         * 
         * @param executionSummary
         *        A summary of the call execution that includes an execution ID, the type of execution (for example,
         *        <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the
         *        following format: yyyy-MM-dd'T'HH:mm:ss'Z'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionSummary(ComplianceExecutionSummary executionSummary);

        /**
         * <p>
         * A summary of the call execution that includes an execution ID, the type of execution (for example,
         * <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the
         * following format: yyyy-MM-dd'T'HH:mm:ss'Z'.
         * </p>
         * This is a convenience that creates an instance of the {@link ComplianceExecutionSummary.Builder} avoiding the
         * need to create one manually via {@link ComplianceExecutionSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComplianceExecutionSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #executionSummary(ComplianceExecutionSummary)}.
         * 
         * @param executionSummary
         *        a consumer that will call methods on {@link ComplianceExecutionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionSummary(ComplianceExecutionSummary)
         */
        default Builder executionSummary(Consumer<ComplianceExecutionSummary.Builder> executionSummary) {
            return executionSummary(ComplianceExecutionSummary.builder().applyMutation(executionSummary).build());
        }

        /**
         * <p>
         * Information about the compliance as defined by the resource type. For example, for a patch compliance type,
         * <code>Items</code> includes information about the PatchSeverity, Classification, and so on.
         * </p>
         * 
         * @param items
         *        Information about the compliance as defined by the resource type. For example, for a patch compliance
         *        type, <code>Items</code> includes information about the PatchSeverity, Classification, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<ComplianceItemEntry> items);

        /**
         * <p>
         * Information about the compliance as defined by the resource type. For example, for a patch compliance type,
         * <code>Items</code> includes information about the PatchSeverity, Classification, and so on.
         * </p>
         * 
         * @param items
         *        Information about the compliance as defined by the resource type. For example, for a patch compliance
         *        type, <code>Items</code> includes information about the PatchSeverity, Classification, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(ComplianceItemEntry... items);

        /**
         * <p>
         * Information about the compliance as defined by the resource type. For example, for a patch compliance type,
         * <code>Items</code> includes information about the PatchSeverity, Classification, and so on.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComplianceItemEntry>.Builder} avoiding the
         * need to create one manually via {@link List<ComplianceItemEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComplianceItemEntry>.Builder#build()} is called immediately
         * and its result is passed to {@link #items(List<ComplianceItemEntry>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<ComplianceItemEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<ComplianceItemEntry>)
         */
        Builder items(Consumer<ComplianceItemEntry.Builder>... items);

        /**
         * <p>
         * MD5 or SHA-256 content hash. The content hash is used to determine if existing information should be
         * overwritten or ignored. If the content hashes match, the request to put compliance information is ignored.
         * </p>
         * 
         * @param itemContentHash
         *        MD5 or SHA-256 content hash. The content hash is used to determine if existing information should be
         *        overwritten or ignored. If the content hashes match, the request to put compliance information is
         *        ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemContentHash(String itemContentHash);

        /**
         * <p>
         * The mode for uploading compliance items. You can specify <code>COMPLETE</code> or <code>PARTIAL</code>. In
         * <code>COMPLETE</code> mode, the system overwrites all existing compliance information for the resource. You
         * must provide a full list of compliance items each time you send the request.
         * </p>
         * <p>
         * In <code>PARTIAL</code> mode, the system overwrites compliance information for a specific association. The
         * association must be configured with <code>SyncCompliance</code> set to <code>MANUAL</code>. By default, all
         * requests use <code>COMPLETE</code> mode.
         * </p>
         * <note>
         * <p>
         * This attribute is only valid for association compliance.
         * </p>
         * </note>
         * 
         * @param uploadType
         *        The mode for uploading compliance items. You can specify <code>COMPLETE</code> or <code>PARTIAL</code>
         *        . In <code>COMPLETE</code> mode, the system overwrites all existing compliance information for the
         *        resource. You must provide a full list of compliance items each time you send the request.</p>
         *        <p>
         *        In <code>PARTIAL</code> mode, the system overwrites compliance information for a specific association.
         *        The association must be configured with <code>SyncCompliance</code> set to <code>MANUAL</code>. By
         *        default, all requests use <code>COMPLETE</code> mode.
         *        </p>
         *        <note>
         *        <p>
         *        This attribute is only valid for association compliance.
         *        </p>
         * @see ComplianceUploadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceUploadType
         */
        Builder uploadType(String uploadType);

        /**
         * <p>
         * The mode for uploading compliance items. You can specify <code>COMPLETE</code> or <code>PARTIAL</code>. In
         * <code>COMPLETE</code> mode, the system overwrites all existing compliance information for the resource. You
         * must provide a full list of compliance items each time you send the request.
         * </p>
         * <p>
         * In <code>PARTIAL</code> mode, the system overwrites compliance information for a specific association. The
         * association must be configured with <code>SyncCompliance</code> set to <code>MANUAL</code>. By default, all
         * requests use <code>COMPLETE</code> mode.
         * </p>
         * <note>
         * <p>
         * This attribute is only valid for association compliance.
         * </p>
         * </note>
         * 
         * @param uploadType
         *        The mode for uploading compliance items. You can specify <code>COMPLETE</code> or <code>PARTIAL</code>
         *        . In <code>COMPLETE</code> mode, the system overwrites all existing compliance information for the
         *        resource. You must provide a full list of compliance items each time you send the request.</p>
         *        <p>
         *        In <code>PARTIAL</code> mode, the system overwrites compliance information for a specific association.
         *        The association must be configured with <code>SyncCompliance</code> set to <code>MANUAL</code>. By
         *        default, all requests use <code>COMPLETE</code> mode.
         *        </p>
         *        <note>
         *        <p>
         *        This attribute is only valid for association compliance.
         *        </p>
         * @see ComplianceUploadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceUploadType
         */
        Builder uploadType(ComplianceUploadType uploadType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String resourceId;

        private String resourceType;

        private String complianceType;

        private ComplianceExecutionSummary executionSummary;

        private List<ComplianceItemEntry> items = DefaultSdkAutoConstructList.getInstance();

        private String itemContentHash;

        private String uploadType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutComplianceItemsRequest model) {
            super(model);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            complianceType(model.complianceType);
            executionSummary(model.executionSummary);
            items(model.items);
            itemContentHash(model.itemContentHash);
            uploadType(model.uploadType);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        @Transient
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        @Transient
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final ComplianceExecutionSummary.Builder getExecutionSummary() {
            return executionSummary != null ? executionSummary.toBuilder() : null;
        }

        public final void setExecutionSummary(ComplianceExecutionSummary.BuilderImpl executionSummary) {
            this.executionSummary = executionSummary != null ? executionSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder executionSummary(ComplianceExecutionSummary executionSummary) {
            this.executionSummary = executionSummary;
            return this;
        }

        public final List<ComplianceItemEntry.Builder> getItems() {
            List<ComplianceItemEntry.Builder> result = ComplianceItemEntryListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<ComplianceItemEntry.BuilderImpl> items) {
            this.items = ComplianceItemEntryListCopier.copyFromBuilder(items);
        }

        @Override
        @Transient
        public final Builder items(Collection<ComplianceItemEntry> items) {
            this.items = ComplianceItemEntryListCopier.copy(items);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder items(ComplianceItemEntry... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder items(Consumer<ComplianceItemEntry.Builder>... items) {
            items(Stream.of(items).map(c -> ComplianceItemEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getItemContentHash() {
            return itemContentHash;
        }

        public final void setItemContentHash(String itemContentHash) {
            this.itemContentHash = itemContentHash;
        }

        @Override
        @Transient
        public final Builder itemContentHash(String itemContentHash) {
            this.itemContentHash = itemContentHash;
            return this;
        }

        public final String getUploadType() {
            return uploadType;
        }

        public final void setUploadType(String uploadType) {
            this.uploadType = uploadType;
        }

        @Override
        @Transient
        public final Builder uploadType(String uploadType) {
            this.uploadType = uploadType;
            return this;
        }

        @Override
        @Transient
        public final Builder uploadType(ComplianceUploadType uploadType) {
            this.uploadType(uploadType == null ? null : uploadType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutComplianceItemsRequest build() {
            return new PutComplianceItemsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
