/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.GetInventoryRequest;
import software.amazon.awssdk.services.ssm.model.GetInventoryResponse;
import software.amazon.awssdk.services.ssm.model.InventoryResultEntity;

public class GetInventoryIterable
implements SdkIterable<GetInventoryResponse> {
    private final SsmClient client;
    private final GetInventoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetInventoryIterable(SsmClient client, GetInventoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetInventoryResponseFetcher();
    }

    public Iterator<GetInventoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InventoryResultEntity> entities() {
        Function<GetInventoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetInventoryResponseFetcher
    implements SyncPageFetcher<GetInventoryResponse> {
        private GetInventoryResponseFetcher() {
        }

        public boolean hasNextPage(GetInventoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetInventoryResponse nextPage(GetInventoryResponse previousPage) {
            if (previousPage == null) {
                return GetInventoryIterable.this.client.getInventory(GetInventoryIterable.this.firstRequest);
            }
            return GetInventoryIterable.this.client.getInventory((GetInventoryRequest)((Object)GetInventoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

