/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePatchPropertiesRequest extends SsmRequest implements
        ToCopyableBuilder<DescribePatchPropertiesRequest.Builder, DescribePatchPropertiesRequest> {
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperatingSystem").getter(getter(DescribePatchPropertiesRequest::operatingSystemAsString))
            .setter(setter(Builder::operatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()).build();

    private static final SdkField<String> PROPERTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Property").getter(getter(DescribePatchPropertiesRequest::propertyAsString))
            .setter(setter(Builder::property))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Property").build()).build();

    private static final SdkField<String> PATCH_SET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PatchSet").getter(getter(DescribePatchPropertiesRequest::patchSetAsString))
            .setter(setter(Builder::patchSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchSet").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribePatchPropertiesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribePatchPropertiesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATING_SYSTEM_FIELD,
            PROPERTY_FIELD, PATCH_SET_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String operatingSystem;

    private final String property;

    private final String patchSet;

    private final Integer maxResults;

    private final String nextToken;

    private DescribePatchPropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.operatingSystem = builder.operatingSystem;
        this.property = builder.property;
        this.patchSet = builder.patchSet;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The operating system type for which to list patches.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return The operating system type for which to list patches.
     * @see OperatingSystem
     */
    public final OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(operatingSystem);
    }

    /**
     * <p>
     * The operating system type for which to list patches.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return The operating system type for which to list patches.
     * @see OperatingSystem
     */
    public final String operatingSystemAsString() {
        return operatingSystem;
    }

    /**
     * <p>
     * The patch property for which you want to view patch details.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #property} will
     * return {@link PatchProperty#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #propertyAsString}.
     * </p>
     * 
     * @return The patch property for which you want to view patch details.
     * @see PatchProperty
     */
    public final PatchProperty property() {
        return PatchProperty.fromValue(property);
    }

    /**
     * <p>
     * The patch property for which you want to view patch details.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #property} will
     * return {@link PatchProperty#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #propertyAsString}.
     * </p>
     * 
     * @return The patch property for which you want to view patch details.
     * @see PatchProperty
     */
    public final String propertyAsString() {
        return property;
    }

    /**
     * <p>
     * Indicates whether to list patches for the Windows operating system or for applications released by Microsoft. Not
     * applicable for the Linux or macOS operating systems.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #patchSet} will
     * return {@link PatchSet#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #patchSetAsString}.
     * </p>
     * 
     * @return Indicates whether to list patches for the Windows operating system or for applications released by
     *         Microsoft. Not applicable for the Linux or macOS operating systems.
     * @see PatchSet
     */
    public final PatchSet patchSet() {
        return PatchSet.fromValue(patchSet);
    }

    /**
     * <p>
     * Indicates whether to list patches for the Windows operating system or for applications released by Microsoft. Not
     * applicable for the Linux or macOS operating systems.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #patchSet} will
     * return {@link PatchSet#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #patchSetAsString}.
     * </p>
     * 
     * @return Indicates whether to list patches for the Windows operating system or for applications released by
     *         Microsoft. Not applicable for the Linux or macOS operating systems.
     * @see PatchSet
     */
    public final String patchSetAsString() {
        return patchSet;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(propertyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(patchSetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchPropertiesRequest)) {
            return false;
        }
        DescribePatchPropertiesRequest other = (DescribePatchPropertiesRequest) obj;
        return Objects.equals(operatingSystemAsString(), other.operatingSystemAsString())
                && Objects.equals(propertyAsString(), other.propertyAsString())
                && Objects.equals(patchSetAsString(), other.patchSetAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePatchPropertiesRequest").add("OperatingSystem", operatingSystemAsString())
                .add("Property", propertyAsString()).add("PatchSet", patchSetAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OperatingSystem":
            return Optional.ofNullable(clazz.cast(operatingSystemAsString()));
        case "Property":
            return Optional.ofNullable(clazz.cast(propertyAsString()));
        case "PatchSet":
            return Optional.ofNullable(clazz.cast(patchSetAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePatchPropertiesRequest, T> g) {
        return obj -> g.apply((DescribePatchPropertiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribePatchPropertiesRequest> {
        /**
         * <p>
         * The operating system type for which to list patches.
         * </p>
         * 
         * @param operatingSystem
         *        The operating system type for which to list patches.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * The operating system type for which to list patches.
         * </p>
         * 
         * @param operatingSystem
         *        The operating system type for which to list patches.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(OperatingSystem operatingSystem);

        /**
         * <p>
         * The patch property for which you want to view patch details.
         * </p>
         * 
         * @param property
         *        The patch property for which you want to view patch details.
         * @see PatchProperty
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchProperty
         */
        Builder property(String property);

        /**
         * <p>
         * The patch property for which you want to view patch details.
         * </p>
         * 
         * @param property
         *        The patch property for which you want to view patch details.
         * @see PatchProperty
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchProperty
         */
        Builder property(PatchProperty property);

        /**
         * <p>
         * Indicates whether to list patches for the Windows operating system or for applications released by Microsoft.
         * Not applicable for the Linux or macOS operating systems.
         * </p>
         * 
         * @param patchSet
         *        Indicates whether to list patches for the Windows operating system or for applications released by
         *        Microsoft. Not applicable for the Linux or macOS operating systems.
         * @see PatchSet
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchSet
         */
        Builder patchSet(String patchSet);

        /**
         * <p>
         * Indicates whether to list patches for the Windows operating system or for applications released by Microsoft.
         * Not applicable for the Linux or macOS operating systems.
         * </p>
         * 
         * @param patchSet
         *        Indicates whether to list patches for the Windows operating system or for applications released by
         *        Microsoft. Not applicable for the Linux or macOS operating systems.
         * @see PatchSet
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchSet
         */
        Builder patchSet(PatchSet patchSet);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String operatingSystem;

        private String property;

        private String patchSet;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchPropertiesRequest model) {
            super(model);
            operatingSystem(model.operatingSystem);
            property(model.property);
            patchSet(model.patchSet);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getOperatingSystem() {
            return operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        @Transient
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        @Transient
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final String getProperty() {
            return property;
        }

        public final void setProperty(String property) {
            this.property = property;
        }

        @Override
        @Transient
        public final Builder property(String property) {
            this.property = property;
            return this;
        }

        @Override
        @Transient
        public final Builder property(PatchProperty property) {
            this.property(property == null ? null : property.toString());
            return this;
        }

        public final String getPatchSet() {
            return patchSet;
        }

        public final void setPatchSet(String patchSet) {
            this.patchSet = patchSet;
        }

        @Override
        @Transient
        public final Builder patchSet(String patchSet) {
            this.patchSet = patchSet;
            return this;
        }

        @Override
        @Transient
        public final Builder patchSet(PatchSet patchSet) {
            this.patchSet(patchSet == null ? null : patchSet.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePatchPropertiesRequest build() {
            return new DescribePatchPropertiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
