/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTask;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMaintenanceWindowTasksResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowTasksResponse> {
    private static final SdkField<List<MaintenanceWindowTask>> TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tasks").getter(DescribeMaintenanceWindowTasksResponse.getter(DescribeMaintenanceWindowTasksResponse::tasks)).setter(DescribeMaintenanceWindowTasksResponse.setter(Builder::tasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MaintenanceWindowTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeMaintenanceWindowTasksResponse.getter(DescribeMaintenanceWindowTasksResponse::nextToken)).setter(DescribeMaintenanceWindowTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASKS_FIELD, NEXT_TOKEN_FIELD));
    private final List<MaintenanceWindowTask> tasks;
    private final String nextToken;

    private DescribeMaintenanceWindowTasksResponse(BuilderImpl builder) {
        super(builder);
        this.tasks = builder.tasks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTasks() {
        return this.tasks != null && !(this.tasks instanceof SdkAutoConstructList);
    }

    public final List<MaintenanceWindowTask> tasks() {
        return this.tasks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTasks() ? this.tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowTasksResponse)) {
            return false;
        }
        DescribeMaintenanceWindowTasksResponse other = (DescribeMaintenanceWindowTasksResponse)((Object)obj);
        return this.hasTasks() == other.hasTasks() && Objects.equals(this.tasks(), other.tasks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMaintenanceWindowTasksResponse").add("Tasks", this.hasTasks() ? this.tasks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tasks": {
                return Optional.ofNullable(clazz.cast(this.tasks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMaintenanceWindowTasksResponse, T> g) {
        return obj -> g.apply((DescribeMaintenanceWindowTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<MaintenanceWindowTask> tasks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowTasksResponse model) {
            super(model);
            this.tasks(model.tasks);
            this.nextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowTask.Builder> getTasks() {
            if (this.tasks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tasks != null ? (Collection)this.tasks.stream().map(MaintenanceWindowTask::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tasks(Collection<MaintenanceWindowTask> tasks) {
            this.tasks = MaintenanceWindowTaskListCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(MaintenanceWindowTask ... tasks) {
            this.tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<MaintenanceWindowTask.Builder> ... tasks) {
            this.tasks(Stream.of(tasks).map(c -> (MaintenanceWindowTask)((MaintenanceWindowTask.Builder)MaintenanceWindowTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTasks(Collection<MaintenanceWindowTask.BuilderImpl> tasks) {
            this.tasks = MaintenanceWindowTaskListCopier.copyFromBuilder(tasks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowTasksResponse build() {
            return new DescribeMaintenanceWindowTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMaintenanceWindowTasksResponse> {
        public Builder tasks(Collection<MaintenanceWindowTask> var1);

        public Builder tasks(MaintenanceWindowTask ... var1);

        public Builder tasks(Consumer<MaintenanceWindowTask.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

