/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an S3 bucket to write instance-level logs to.
 * </p>
 * <note>
 * <p>
 * <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the
 * <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the
 * <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for
 * the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingInfo implements SdkPojo, Serializable, ToCopyableBuilder<LoggingInfo.Builder, LoggingInfo> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(LoggingInfo::s3BucketName)).setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3KeyPrefix").getter(getter(LoggingInfo::s3KeyPrefix)).setter(setter(Builder::s3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()).build();

    private static final SdkField<String> S3_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Region").getter(getter(LoggingInfo::s3Region)).setter(setter(Builder::s3Region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Region").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD,
            S3_KEY_PREFIX_FIELD, S3_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3BucketName;

    private final String s3KeyPrefix;

    private final String s3Region;

    private LoggingInfo(BuilderImpl builder) {
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.s3Region = builder.s3Region;
    }

    /**
     * <p>
     * The name of an S3 bucket where execution logs are stored .
     * </p>
     * 
     * @return The name of an S3 bucket where execution logs are stored .
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * (Optional) The S3 bucket subfolder.
     * </p>
     * 
     * @return (Optional) The S3 bucket subfolder.
     */
    public final String s3KeyPrefix() {
        return s3KeyPrefix;
    }

    /**
     * <p>
     * The Region where the S3 bucket is located.
     * </p>
     * 
     * @return The Region where the S3 bucket is located.
     */
    public final String s3Region() {
        return s3Region;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(s3Region());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingInfo)) {
            return false;
        }
        LoggingInfo other = (LoggingInfo) obj;
        return Objects.equals(s3BucketName(), other.s3BucketName()) && Objects.equals(s3KeyPrefix(), other.s3KeyPrefix())
                && Objects.equals(s3Region(), other.s3Region());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoggingInfo").add("S3BucketName", s3BucketName()).add("S3KeyPrefix", s3KeyPrefix())
                .add("S3Region", s3Region()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "S3KeyPrefix":
            return Optional.ofNullable(clazz.cast(s3KeyPrefix()));
        case "S3Region":
            return Optional.ofNullable(clazz.cast(s3Region()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingInfo, T> g) {
        return obj -> g.apply((LoggingInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingInfo> {
        /**
         * <p>
         * The name of an S3 bucket where execution logs are stored .
         * </p>
         * 
         * @param s3BucketName
         *        The name of an S3 bucket where execution logs are stored .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * (Optional) The S3 bucket subfolder.
         * </p>
         * 
         * @param s3KeyPrefix
         *        (Optional) The S3 bucket subfolder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KeyPrefix(String s3KeyPrefix);

        /**
         * <p>
         * The Region where the S3 bucket is located.
         * </p>
         * 
         * @param s3Region
         *        The Region where the S3 bucket is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Region(String s3Region);
    }

    static final class BuilderImpl implements Builder {
        private String s3BucketName;

        private String s3KeyPrefix;

        private String s3Region;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingInfo model) {
            s3BucketName(model.s3BucketName);
            s3KeyPrefix(model.s3KeyPrefix);
            s3Region(model.s3Region);
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3KeyPrefix() {
            return s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public final String getS3Region() {
            return s3Region;
        }

        @Override
        public final Builder s3Region(String s3Region) {
            this.s3Region = s3Region;
            return this;
        }

        public final void setS3Region(String s3Region) {
            this.s3Region = s3Region;
        }

        @Override
        public LoggingInfo build() {
            return new LoggingInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
