/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDocumentRequest extends SsmRequest implements
        ToCopyableBuilder<CreateDocumentRequest.Builder, CreateDocumentRequest> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(CreateDocumentRequest::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<List<DocumentRequires>> REQUIRES_FIELD = SdkField
            .<List<DocumentRequires>> builder(MarshallingType.LIST)
            .memberName("Requires")
            .getter(getter(CreateDocumentRequest::requires))
            .setter(setter(Builder::requires))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Requires").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentRequires> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentRequires::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AttachmentsSource>> ATTACHMENTS_FIELD = SdkField
            .<List<AttachmentsSource>> builder(MarshallingType.LIST)
            .memberName("Attachments")
            .getter(getter(CreateDocumentRequest::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachmentsSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachmentsSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateDocumentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionName").getter(getter(CreateDocumentRequest::versionName)).setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()).build();

    private static final SdkField<String> DOCUMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentType").getter(getter(CreateDocumentRequest::documentTypeAsString))
            .setter(setter(Builder::documentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentType").build()).build();

    private static final SdkField<String> DOCUMENT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentFormat").getter(getter(CreateDocumentRequest::documentFormatAsString))
            .setter(setter(Builder::documentFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentFormat").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetType").getter(getter(CreateDocumentRequest::targetType)).setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDocumentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, REQUIRES_FIELD,
            ATTACHMENTS_FIELD, NAME_FIELD, VERSION_NAME_FIELD, DOCUMENT_TYPE_FIELD, DOCUMENT_FORMAT_FIELD, TARGET_TYPE_FIELD,
            TAGS_FIELD));

    private final String content;

    private final List<DocumentRequires> requires;

    private final List<AttachmentsSource> attachments;

    private final String name;

    private final String versionName;

    private final String documentType;

    private final String documentFormat;

    private final String targetType;

    private final List<Tag> tags;

    private CreateDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
        this.requires = builder.requires;
        this.attachments = builder.attachments;
        this.name = builder.name;
        this.versionName = builder.versionName;
        this.documentType = builder.documentType;
        this.documentFormat = builder.documentFormat;
        this.targetType = builder.targetType;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The content for the new SSM document in JSON or YAML format. We recommend storing the contents for your new
     * document in an external JSON or YAML file and referencing the file in a command.
     * </p>
     * <p>
     * For examples, see the following topics in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM
     * document (AWS API)</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-cli.html">Create an SSM
     * document (AWS CLI)</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM
     * document (API)</a>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The content for the new SSM document in JSON or YAML format. We recommend storing the contents for your
     *         new document in an external JSON or YAML file and referencing the file in a command.</p>
     *         <p>
     *         For examples, see the following topics in the <i>AWS Systems Manager User Guide</i>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create
     *         an SSM document (AWS API)</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-cli.html">Create
     *         an SSM document (AWS CLI)</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create
     *         an SSM document (API)</a>
     *         </p>
     *         </li>
     */
    public final String content() {
        return content;
    }

    /**
     * Returns true if the Requires property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRequires() {
        return requires != null && !(requires instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of SSM documents required by a document. This parameter is used exclusively by AWS AppConfig. When a user
     * creates an AppConfig configuration in an SSM document, the user must also specify a required document for
     * validation purposes. In this case, an <code>ApplicationConfiguration</code> document requires an
     * <code>ApplicationConfigurationSchema</code> document for validation purposes. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/appconfig.html">AWS AppConfig</a> in the
     * <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRequires()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of SSM documents required by a document. This parameter is used exclusively by AWS AppConfig. When
     *         a user creates an AppConfig configuration in an SSM document, the user must also specify a required
     *         document for validation purposes. In this case, an <code>ApplicationConfiguration</code> document
     *         requires an <code>ApplicationConfigurationSchema</code> document for validation purposes. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/systems-manager/latest/userguide/appconfig.html">AWS AppConfig</a> in
     *         the <i>AWS Systems Manager User Guide</i>.
     */
    public final List<DocumentRequires> requires() {
        return requires;
    }

    /**
     * Returns true if the Attachments property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key and value pairs that describe attachments to a version of a document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttachments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of key and value pairs that describe attachments to a version of a document.
     */
    public final List<AttachmentsSource> attachments() {
        return attachments;
    }

    /**
     * <p>
     * A name for the Systems Manager document.
     * </p>
     * <important>
     * <p>
     * You can't use the following strings as document name prefixes. These are reserved by AWS for use as document name
     * prefixes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws-</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>amazon</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>amzn</code>
     * </p>
     * </li>
     * </ul>
     * </important>
     * 
     * @return A name for the Systems Manager document.</p> <important>
     *         <p>
     *         You can't use the following strings as document name prefixes. These are reserved by AWS for use as
     *         document name prefixes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>aws-</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>amazon</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>amzn</code>
     *         </p>
     *         </li>
     *         </ul>
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An optional field specifying the version of the artifact you are creating with the document. For example,
     * "Release 12, Update 6". This value is unique across all versions of a document, and cannot be changed.
     * </p>
     * 
     * @return An optional field specifying the version of the artifact you are creating with the document. For example,
     *         "Release 12, Update 6". This value is unique across all versions of a document, and cannot be changed.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * <p>
     * The type of document to create.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentType} will
     * return {@link DocumentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #documentTypeAsString}.
     * </p>
     * 
     * @return The type of document to create.
     * @see DocumentType
     */
    public final DocumentType documentType() {
        return DocumentType.fromValue(documentType);
    }

    /**
     * <p>
     * The type of document to create.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentType} will
     * return {@link DocumentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #documentTypeAsString}.
     * </p>
     * 
     * @return The type of document to create.
     * @see DocumentType
     */
    public final String documentTypeAsString() {
        return documentType;
    }

    /**
     * <p>
     * Specify the document format for the request. The document format can be JSON, YAML, or TEXT. JSON is the default
     * format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentFormat}
     * will return {@link DocumentFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #documentFormatAsString}.
     * </p>
     * 
     * @return Specify the document format for the request. The document format can be JSON, YAML, or TEXT. JSON is the
     *         default format.
     * @see DocumentFormat
     */
    public final DocumentFormat documentFormat() {
        return DocumentFormat.fromValue(documentFormat);
    }

    /**
     * <p>
     * Specify the document format for the request. The document format can be JSON, YAML, or TEXT. JSON is the default
     * format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentFormat}
     * will return {@link DocumentFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #documentFormatAsString}.
     * </p>
     * 
     * @return Specify the document format for the request. The document format can be JSON, YAML, or TEXT. JSON is the
     *         default format.
     * @see DocumentFormat
     */
    public final String documentFormatAsString() {
        return documentFormat;
    }

    /**
     * <p>
     * Specify a target type to define the kinds of resources the document can run on. For example, to run a document on
     * EC2 instances, specify the following value: /AWS::EC2::Instance. If you specify a value of '/' the document can
     * run on all types of resources. If you don't specify a value, the document can't run on any resources. For a list
     * of valid resource types, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">AWS
     * resource and property types reference</a> in the <i>AWS CloudFormation User Guide</i>.
     * </p>
     * 
     * @return Specify a target type to define the kinds of resources the document can run on. For example, to run a
     *         document on EC2 instances, specify the following value: /AWS::EC2::Instance. If you specify a value of
     *         '/' the document can run on all types of resources. If you don't specify a value, the document can't run
     *         on any resources. For a list of valid resource types, see <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">AWS
     *         resource and property types reference</a> in the <i>AWS CloudFormation User Guide</i>.
     */
    public final String targetType() {
        return targetType;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such
     * as by purpose, owner, or environment. For example, you might want to tag an SSM document to identify the types of
     * targets or the environment where it will run. In this case, you could specify the following key name/value pairs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Key=OS,Value=Windows</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Environment,Value=Production</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * To add tags to an existing SSM document, use the <a>AddTagsToResource</a> action.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different
     *         ways, such as by purpose, owner, or environment. For example, you might want to tag an SSM document to
     *         identify the types of targets or the environment where it will run. In this case, you could specify the
     *         following key name/value pairs:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Key=OS,Value=Windows</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Key=Environment,Value=Production</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         To add tags to an existing SSM document, use the <a>AddTagsToResource</a> action.
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequires() ? requires() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments() ? attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(documentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(documentFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetType());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDocumentRequest)) {
            return false;
        }
        CreateDocumentRequest other = (CreateDocumentRequest) obj;
        return Objects.equals(content(), other.content()) && hasRequires() == other.hasRequires()
                && Objects.equals(requires(), other.requires()) && hasAttachments() == other.hasAttachments()
                && Objects.equals(attachments(), other.attachments()) && Objects.equals(name(), other.name())
                && Objects.equals(versionName(), other.versionName())
                && Objects.equals(documentTypeAsString(), other.documentTypeAsString())
                && Objects.equals(documentFormatAsString(), other.documentFormatAsString())
                && Objects.equals(targetType(), other.targetType()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDocumentRequest").add("Content", content())
                .add("Requires", hasRequires() ? requires() : null).add("Attachments", hasAttachments() ? attachments() : null)
                .add("Name", name()).add("VersionName", versionName()).add("DocumentType", documentTypeAsString())
                .add("DocumentFormat", documentFormatAsString()).add("TargetType", targetType())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Requires":
            return Optional.ofNullable(clazz.cast(requires()));
        case "Attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "VersionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "DocumentType":
            return Optional.ofNullable(clazz.cast(documentTypeAsString()));
        case "DocumentFormat":
            return Optional.ofNullable(clazz.cast(documentFormatAsString()));
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetType()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDocumentRequest, T> g) {
        return obj -> g.apply((CreateDocumentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDocumentRequest> {
        /**
         * <p>
         * The content for the new SSM document in JSON or YAML format. We recommend storing the contents for your new
         * document in an external JSON or YAML file and referencing the file in a command.
         * </p>
         * <p>
         * For examples, see the following topics in the <i>AWS Systems Manager User Guide</i>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an
         * SSM document (AWS API)</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-cli.html">Create an
         * SSM document (AWS CLI)</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an
         * SSM document (API)</a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param content
         *        The content for the new SSM document in JSON or YAML format. We recommend storing the contents for
         *        your new document in an external JSON or YAML file and referencing the file in a command.</p>
         *        <p>
         *        For examples, see the following topics in the <i>AWS Systems Manager User Guide</i>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">
         *        Create an SSM document (AWS API)</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-cli.html">
         *        Create an SSM document (AWS CLI)</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">
         *        Create an SSM document (API)</a>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * A list of SSM documents required by a document. This parameter is used exclusively by AWS AppConfig. When a
         * user creates an AppConfig configuration in an SSM document, the user must also specify a required document
         * for validation purposes. In this case, an <code>ApplicationConfiguration</code> document requires an
         * <code>ApplicationConfigurationSchema</code> document for validation purposes. For more information, see <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/appconfig.html">AWS AppConfig</a> in the
         * <i>AWS Systems Manager User Guide</i>.
         * </p>
         * 
         * @param requires
         *        A list of SSM documents required by a document. This parameter is used exclusively by AWS AppConfig.
         *        When a user creates an AppConfig configuration in an SSM document, the user must also specify a
         *        required document for validation purposes. In this case, an <code>ApplicationConfiguration</code>
         *        document requires an <code>ApplicationConfigurationSchema</code> document for validation purposes. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/appconfig.html">AWS AppConfig</a>
         *        in the <i>AWS Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requires(Collection<DocumentRequires> requires);

        /**
         * <p>
         * A list of SSM documents required by a document. This parameter is used exclusively by AWS AppConfig. When a
         * user creates an AppConfig configuration in an SSM document, the user must also specify a required document
         * for validation purposes. In this case, an <code>ApplicationConfiguration</code> document requires an
         * <code>ApplicationConfigurationSchema</code> document for validation purposes. For more information, see <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/appconfig.html">AWS AppConfig</a> in the
         * <i>AWS Systems Manager User Guide</i>.
         * </p>
         * 
         * @param requires
         *        A list of SSM documents required by a document. This parameter is used exclusively by AWS AppConfig.
         *        When a user creates an AppConfig configuration in an SSM document, the user must also specify a
         *        required document for validation purposes. In this case, an <code>ApplicationConfiguration</code>
         *        document requires an <code>ApplicationConfigurationSchema</code> document for validation purposes. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/appconfig.html">AWS AppConfig</a>
         *        in the <i>AWS Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requires(DocumentRequires... requires);

        /**
         * <p>
         * A list of SSM documents required by a document. This parameter is used exclusively by AWS AppConfig. When a
         * user creates an AppConfig configuration in an SSM document, the user must also specify a required document
         * for validation purposes. In this case, an <code>ApplicationConfiguration</code> document requires an
         * <code>ApplicationConfigurationSchema</code> document for validation purposes. For more information, see <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/appconfig.html">AWS AppConfig</a> in the
         * <i>AWS Systems Manager User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DocumentRequires>.Builder} avoiding the
         * need to create one manually via {@link List<DocumentRequires>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentRequires>.Builder#build()} is called immediately and
         * its result is passed to {@link #requires(List<DocumentRequires>)}.
         * 
         * @param requires
         *        a consumer that will call methods on {@link List<DocumentRequires>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requires(List<DocumentRequires>)
         */
        Builder requires(Consumer<DocumentRequires.Builder>... requires);

        /**
         * <p>
         * A list of key and value pairs that describe attachments to a version of a document.
         * </p>
         * 
         * @param attachments
         *        A list of key and value pairs that describe attachments to a version of a document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<AttachmentsSource> attachments);

        /**
         * <p>
         * A list of key and value pairs that describe attachments to a version of a document.
         * </p>
         * 
         * @param attachments
         *        A list of key and value pairs that describe attachments to a version of a document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(AttachmentsSource... attachments);

        /**
         * <p>
         * A list of key and value pairs that describe attachments to a version of a document.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttachmentsSource>.Builder} avoiding the
         * need to create one manually via {@link List<AttachmentsSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttachmentsSource>.Builder#build()} is called immediately
         * and its result is passed to {@link #attachments(List<AttachmentsSource>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on {@link List<AttachmentsSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(List<AttachmentsSource>)
         */
        Builder attachments(Consumer<AttachmentsSource.Builder>... attachments);

        /**
         * <p>
         * A name for the Systems Manager document.
         * </p>
         * <important>
         * <p>
         * You can't use the following strings as document name prefixes. These are reserved by AWS for use as document
         * name prefixes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>aws-</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>amazon</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>amzn</code>
         * </p>
         * </li>
         * </ul>
         * </important>
         * 
         * @param name
         *        A name for the Systems Manager document.</p> <important>
         *        <p>
         *        You can't use the following strings as document name prefixes. These are reserved by AWS for use as
         *        document name prefixes:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>aws-</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>amazon</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>amzn</code>
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional field specifying the version of the artifact you are creating with the document. For example,
         * "Release 12, Update 6". This value is unique across all versions of a document, and cannot be changed.
         * </p>
         * 
         * @param versionName
         *        An optional field specifying the version of the artifact you are creating with the document. For
         *        example, "Release 12, Update 6". This value is unique across all versions of a document, and cannot be
         *        changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * The type of document to create.
         * </p>
         * 
         * @param documentType
         *        The type of document to create.
         * @see DocumentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentType
         */
        Builder documentType(String documentType);

        /**
         * <p>
         * The type of document to create.
         * </p>
         * 
         * @param documentType
         *        The type of document to create.
         * @see DocumentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentType
         */
        Builder documentType(DocumentType documentType);

        /**
         * <p>
         * Specify the document format for the request. The document format can be JSON, YAML, or TEXT. JSON is the
         * default format.
         * </p>
         * 
         * @param documentFormat
         *        Specify the document format for the request. The document format can be JSON, YAML, or TEXT. JSON is
         *        the default format.
         * @see DocumentFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentFormat
         */
        Builder documentFormat(String documentFormat);

        /**
         * <p>
         * Specify the document format for the request. The document format can be JSON, YAML, or TEXT. JSON is the
         * default format.
         * </p>
         * 
         * @param documentFormat
         *        Specify the document format for the request. The document format can be JSON, YAML, or TEXT. JSON is
         *        the default format.
         * @see DocumentFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentFormat
         */
        Builder documentFormat(DocumentFormat documentFormat);

        /**
         * <p>
         * Specify a target type to define the kinds of resources the document can run on. For example, to run a
         * document on EC2 instances, specify the following value: /AWS::EC2::Instance. If you specify a value of '/'
         * the document can run on all types of resources. If you don't specify a value, the document can't run on any
         * resources. For a list of valid resource types, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">AWS
         * resource and property types reference</a> in the <i>AWS CloudFormation User Guide</i>.
         * </p>
         * 
         * @param targetType
         *        Specify a target type to define the kinds of resources the document can run on. For example, to run a
         *        document on EC2 instances, specify the following value: /AWS::EC2::Instance. If you specify a value of
         *        '/' the document can run on all types of resources. If you don't specify a value, the document can't
         *        run on any resources. For a list of valid resource types, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         *        >AWS resource and property types reference</a> in the <i>AWS CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways,
         * such as by purpose, owner, or environment. For example, you might want to tag an SSM document to identify the
         * types of targets or the environment where it will run. In this case, you could specify the following key
         * name/value pairs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key=OS,Value=Windows</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=Environment,Value=Production</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * To add tags to an existing SSM document, use the <a>AddTagsToResource</a> action.
         * </p>
         * </note>
         * 
         * @param tags
         *        Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different
         *        ways, such as by purpose, owner, or environment. For example, you might want to tag an SSM document to
         *        identify the types of targets or the environment where it will run. In this case, you could specify
         *        the following key name/value pairs:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Key=OS,Value=Windows</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Key=Environment,Value=Production</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        To add tags to an existing SSM document, use the <a>AddTagsToResource</a> action.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways,
         * such as by purpose, owner, or environment. For example, you might want to tag an SSM document to identify the
         * types of targets or the environment where it will run. In this case, you could specify the following key
         * name/value pairs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key=OS,Value=Windows</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=Environment,Value=Production</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * To add tags to an existing SSM document, use the <a>AddTagsToResource</a> action.
         * </p>
         * </note>
         * 
         * @param tags
         *        Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different
         *        ways, such as by purpose, owner, or environment. For example, you might want to tag an SSM document to
         *        identify the types of targets or the environment where it will run. In this case, you could specify
         *        the following key name/value pairs:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Key=OS,Value=Windows</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Key=Environment,Value=Production</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        To add tags to an existing SSM document, use the <a>AddTagsToResource</a> action.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways,
         * such as by purpose, owner, or environment. For example, you might want to tag an SSM document to identify the
         * types of targets or the environment where it will run. In this case, you could specify the following key
         * name/value pairs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key=OS,Value=Windows</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=Environment,Value=Production</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * To add tags to an existing SSM document, use the <a>AddTagsToResource</a> action.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String content;

        private List<DocumentRequires> requires = DefaultSdkAutoConstructList.getInstance();

        private List<AttachmentsSource> attachments = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String versionName;

        private String documentType;

        private String documentFormat;

        private String targetType;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDocumentRequest model) {
            super(model);
            content(model.content);
            requires(model.requires);
            attachments(model.attachments);
            name(model.name);
            versionName(model.versionName);
            documentType(model.documentType);
            documentFormat(model.documentFormat);
            targetType(model.targetType);
            tags(model.tags);
        }

        public final String getContent() {
            return content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final Collection<DocumentRequires.Builder> getRequires() {
            if (requires instanceof SdkAutoConstructList) {
                return null;
            }
            return requires != null ? requires.stream().map(DocumentRequires::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder requires(Collection<DocumentRequires> requires) {
            this.requires = DocumentRequiresListCopier.copy(requires);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requires(DocumentRequires... requires) {
            requires(Arrays.asList(requires));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requires(Consumer<DocumentRequires.Builder>... requires) {
            requires(Stream.of(requires).map(c -> DocumentRequires.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRequires(Collection<DocumentRequires.BuilderImpl> requires) {
            this.requires = DocumentRequiresListCopier.copyFromBuilder(requires);
        }

        public final Collection<AttachmentsSource.Builder> getAttachments() {
            if (attachments instanceof SdkAutoConstructList) {
                return null;
            }
            return attachments != null ? attachments.stream().map(AttachmentsSource::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder attachments(Collection<AttachmentsSource> attachments) {
            this.attachments = AttachmentsSourceListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(AttachmentsSource... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<AttachmentsSource.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> AttachmentsSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttachments(Collection<AttachmentsSource.BuilderImpl> attachments) {
            this.attachments = AttachmentsSourceListCopier.copyFromBuilder(attachments);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersionName() {
            return versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        public final String getDocumentType() {
            return documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        public final Builder documentType(DocumentType documentType) {
            this.documentType(documentType == null ? null : documentType.toString());
            return this;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        public final String getDocumentFormat() {
            return documentFormat;
        }

        @Override
        public final Builder documentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
            return this;
        }

        @Override
        public final Builder documentFormat(DocumentFormat documentFormat) {
            this.documentFormat(documentFormat == null ? null : documentFormat.toString());
            return this;
        }

        public final void setDocumentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
        }

        public final String getTargetType() {
            return targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDocumentRequest build() {
            return new CreateDocumentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
