/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsResponse;
import software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemSummary;

public class ListOpsItemRelatedItemsPublisher
implements SdkPublisher<ListOpsItemRelatedItemsResponse> {
    private final SsmAsyncClient client;
    private final ListOpsItemRelatedItemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOpsItemRelatedItemsPublisher(SsmAsyncClient client, ListOpsItemRelatedItemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOpsItemRelatedItemsPublisher(SsmAsyncClient client, ListOpsItemRelatedItemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOpsItemRelatedItemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOpsItemRelatedItemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OpsItemRelatedItemSummary> summaries() {
        Function<ListOpsItemRelatedItemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOpsItemRelatedItemsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOpsItemRelatedItemsResponseFetcher
    implements AsyncPageFetcher<ListOpsItemRelatedItemsResponse> {
        private ListOpsItemRelatedItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListOpsItemRelatedItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOpsItemRelatedItemsResponse> nextPage(ListOpsItemRelatedItemsResponse previousPage) {
            if (previousPage == null) {
                return ListOpsItemRelatedItemsPublisher.this.client.listOpsItemRelatedItems(ListOpsItemRelatedItemsPublisher.this.firstRequest);
            }
            return ListOpsItemRelatedItemsPublisher.this.client.listOpsItemRelatedItems((ListOpsItemRelatedItemsRequest)((Object)ListOpsItemRelatedItemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

