/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DocumentType {
    COMMAND("Command"),
    POLICY("Policy"),
    AUTOMATION("Automation"),
    SESSION("Session"),
    PACKAGE("Package"),
    APPLICATION_CONFIGURATION("ApplicationConfiguration"),
    APPLICATION_CONFIGURATION_SCHEMA("ApplicationConfigurationSchema"),
    DEPLOYMENT_STRATEGY("DeploymentStrategy"),
    CHANGE_CALENDAR("ChangeCalendar"),
    AUTOMATION_CHANGE_TEMPLATE("Automation.ChangeTemplate"),
    PROBLEM_ANALYSIS("ProblemAnalysis"),
    PROBLEM_ANALYSIS_TEMPLATE("ProblemAnalysisTemplate"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DocumentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DocumentType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentType> knownValues() {
        return Stream.of(DocumentType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

