/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.AssociationExecution;
import software.amazon.awssdk.services.ssm.model.AssociationExecutionsListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAssociationExecutionsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeAssociationExecutionsResponse> {
    private static final SdkField<List<AssociationExecution>> ASSOCIATION_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociationExecutions").getter(DescribeAssociationExecutionsResponse.getter(DescribeAssociationExecutionsResponse::associationExecutions)).setter(DescribeAssociationExecutionsResponse.setter(Builder::associationExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociationExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAssociationExecutionsResponse.getter(DescribeAssociationExecutionsResponse::nextToken)).setter(DescribeAssociationExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_EXECUTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AssociationExecution> associationExecutions;
    private final String nextToken;

    private DescribeAssociationExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.associationExecutions = builder.associationExecutions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssociationExecutions() {
        return this.associationExecutions != null && !(this.associationExecutions instanceof SdkAutoConstructList);
    }

    public final List<AssociationExecution> associationExecutions() {
        return this.associationExecutions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociationExecutions() ? this.associationExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssociationExecutionsResponse)) {
            return false;
        }
        DescribeAssociationExecutionsResponse other = (DescribeAssociationExecutionsResponse)((Object)obj);
        return this.hasAssociationExecutions() == other.hasAssociationExecutions() && Objects.equals(this.associationExecutions(), other.associationExecutions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAssociationExecutionsResponse").add("AssociationExecutions", this.hasAssociationExecutions() ? this.associationExecutions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationExecutions": {
                return Optional.ofNullable(clazz.cast(this.associationExecutions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssociationExecutionsResponse, T> g) {
        return obj -> g.apply((DescribeAssociationExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<AssociationExecution> associationExecutions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssociationExecutionsResponse model) {
            super(model);
            this.associationExecutions(model.associationExecutions);
            this.nextToken(model.nextToken);
        }

        public final List<AssociationExecution.Builder> getAssociationExecutions() {
            List<AssociationExecution.Builder> result = AssociationExecutionsListCopier.copyToBuilder(this.associationExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder associationExecutions(Collection<AssociationExecution> associationExecutions) {
            this.associationExecutions = AssociationExecutionsListCopier.copy(associationExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationExecutions(AssociationExecution ... associationExecutions) {
            this.associationExecutions(Arrays.asList(associationExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationExecutions(Consumer<AssociationExecution.Builder> ... associationExecutions) {
            this.associationExecutions(Stream.of(associationExecutions).map(c -> (AssociationExecution)((AssociationExecution.Builder)AssociationExecution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssociationExecutions(Collection<AssociationExecution.BuilderImpl> associationExecutions) {
            this.associationExecutions = AssociationExecutionsListCopier.copyFromBuilder(associationExecutions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAssociationExecutionsResponse build() {
            return new DescribeAssociationExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAssociationExecutionsResponse> {
        public Builder associationExecutions(Collection<AssociationExecution> var1);

        public Builder associationExecutions(AssociationExecution ... var1);

        public Builder associationExecutions(Consumer<AssociationExecution.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

