/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the approval status of a patch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PatchStatus implements SdkPojo, Serializable, ToCopyableBuilder<PatchStatus.Builder, PatchStatus> {
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentStatus").getter(getter(PatchStatus::deploymentStatusAsString))
            .setter(setter(Builder::deploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()).build();

    private static final SdkField<String> COMPLIANCE_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplianceLevel").getter(getter(PatchStatus::complianceLevelAsString))
            .setter(setter(Builder::complianceLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceLevel").build()).build();

    private static final SdkField<Instant> APPROVAL_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ApprovalDate").getter(getter(PatchStatus::approvalDate)).setter(setter(Builder::approvalDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_STATUS_FIELD,
            COMPLIANCE_LEVEL_FIELD, APPROVAL_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deploymentStatus;

    private final String complianceLevel;

    private final Instant approvalDate;

    private PatchStatus(BuilderImpl builder) {
        this.deploymentStatus = builder.deploymentStatus;
        this.complianceLevel = builder.complianceLevel;
        this.approvalDate = builder.approvalDate;
    }

    /**
     * <p>
     * The approval status of a patch (APPROVED, PENDING_APPROVAL, EXPLICIT_APPROVED, EXPLICIT_REJECTED).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link PatchDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The approval status of a patch (APPROVED, PENDING_APPROVAL, EXPLICIT_APPROVED, EXPLICIT_REJECTED).
     * @see PatchDeploymentStatus
     */
    public final PatchDeploymentStatus deploymentStatus() {
        return PatchDeploymentStatus.fromValue(deploymentStatus);
    }

    /**
     * <p>
     * The approval status of a patch (APPROVED, PENDING_APPROVAL, EXPLICIT_APPROVED, EXPLICIT_REJECTED).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link PatchDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The approval status of a patch (APPROVED, PENDING_APPROVAL, EXPLICIT_APPROVED, EXPLICIT_REJECTED).
     * @see PatchDeploymentStatus
     */
    public final String deploymentStatusAsString() {
        return deploymentStatus;
    }

    /**
     * <p>
     * The compliance severity level for a patch.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceLevel}
     * will return {@link PatchComplianceLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #complianceLevelAsString}.
     * </p>
     * 
     * @return The compliance severity level for a patch.
     * @see PatchComplianceLevel
     */
    public final PatchComplianceLevel complianceLevel() {
        return PatchComplianceLevel.fromValue(complianceLevel);
    }

    /**
     * <p>
     * The compliance severity level for a patch.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceLevel}
     * will return {@link PatchComplianceLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #complianceLevelAsString}.
     * </p>
     * 
     * @return The compliance severity level for a patch.
     * @see PatchComplianceLevel
     */
    public final String complianceLevelAsString() {
        return complianceLevel;
    }

    /**
     * <p>
     * The date the patch was approved (or will be approved if the status is PENDING_APPROVAL).
     * </p>
     * 
     * @return The date the patch was approved (or will be approved if the status is PENDING_APPROVAL).
     */
    public final Instant approvalDate() {
        return approvalDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(complianceLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(approvalDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchStatus)) {
            return false;
        }
        PatchStatus other = (PatchStatus) obj;
        return Objects.equals(deploymentStatusAsString(), other.deploymentStatusAsString())
                && Objects.equals(complianceLevelAsString(), other.complianceLevelAsString())
                && Objects.equals(approvalDate(), other.approvalDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PatchStatus").add("DeploymentStatus", deploymentStatusAsString())
                .add("ComplianceLevel", complianceLevelAsString()).add("ApprovalDate", approvalDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatusAsString()));
        case "ComplianceLevel":
            return Optional.ofNullable(clazz.cast(complianceLevelAsString()));
        case "ApprovalDate":
            return Optional.ofNullable(clazz.cast(approvalDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PatchStatus, T> g) {
        return obj -> g.apply((PatchStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PatchStatus> {
        /**
         * <p>
         * The approval status of a patch (APPROVED, PENDING_APPROVAL, EXPLICIT_APPROVED, EXPLICIT_REJECTED).
         * </p>
         * 
         * @param deploymentStatus
         *        The approval status of a patch (APPROVED, PENDING_APPROVAL, EXPLICIT_APPROVED, EXPLICIT_REJECTED).
         * @see PatchDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchDeploymentStatus
         */
        Builder deploymentStatus(String deploymentStatus);

        /**
         * <p>
         * The approval status of a patch (APPROVED, PENDING_APPROVAL, EXPLICIT_APPROVED, EXPLICIT_REJECTED).
         * </p>
         * 
         * @param deploymentStatus
         *        The approval status of a patch (APPROVED, PENDING_APPROVAL, EXPLICIT_APPROVED, EXPLICIT_REJECTED).
         * @see PatchDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchDeploymentStatus
         */
        Builder deploymentStatus(PatchDeploymentStatus deploymentStatus);

        /**
         * <p>
         * The compliance severity level for a patch.
         * </p>
         * 
         * @param complianceLevel
         *        The compliance severity level for a patch.
         * @see PatchComplianceLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchComplianceLevel
         */
        Builder complianceLevel(String complianceLevel);

        /**
         * <p>
         * The compliance severity level for a patch.
         * </p>
         * 
         * @param complianceLevel
         *        The compliance severity level for a patch.
         * @see PatchComplianceLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchComplianceLevel
         */
        Builder complianceLevel(PatchComplianceLevel complianceLevel);

        /**
         * <p>
         * The date the patch was approved (or will be approved if the status is PENDING_APPROVAL).
         * </p>
         * 
         * @param approvalDate
         *        The date the patch was approved (or will be approved if the status is PENDING_APPROVAL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalDate(Instant approvalDate);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentStatus;

        private String complianceLevel;

        private Instant approvalDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchStatus model) {
            deploymentStatus(model.deploymentStatus);
            complianceLevel(model.complianceLevel);
            approvalDate(model.approvalDate);
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(PatchDeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        public final String getComplianceLevel() {
            return complianceLevel;
        }

        @Override
        public final Builder complianceLevel(String complianceLevel) {
            this.complianceLevel = complianceLevel;
            return this;
        }

        @Override
        public final Builder complianceLevel(PatchComplianceLevel complianceLevel) {
            this.complianceLevel(complianceLevel == null ? null : complianceLevel.toString());
            return this;
        }

        public final void setComplianceLevel(String complianceLevel) {
            this.complianceLevel = complianceLevel;
        }

        public final Instant getApprovalDate() {
            return approvalDate;
        }

        @Override
        public final Builder approvalDate(Instant approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public final void setApprovalDate(Instant approvalDate) {
            this.approvalDate = approvalDate;
        }

        @Override
        public PatchStatus build() {
            return new PatchStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
