/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregisterTargetFromMaintenanceWindowResponse extends SsmResponse implements
        ToCopyableBuilder<DeregisterTargetFromMaintenanceWindowResponse.Builder, DeregisterTargetFromMaintenanceWindowResponse> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WindowId").getter(getter(DeregisterTargetFromMaintenanceWindowResponse::windowId))
            .setter(setter(Builder::windowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()).build();

    private static final SdkField<String> WINDOW_TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WindowTargetId").getter(getter(DeregisterTargetFromMaintenanceWindowResponse::windowTargetId))
            .setter(setter(Builder::windowTargetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowTargetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD,
            WINDOW_TARGET_ID_FIELD));

    private final String windowId;

    private final String windowTargetId;

    private DeregisterTargetFromMaintenanceWindowResponse(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.windowTargetId = builder.windowTargetId;
    }

    /**
     * <p>
     * The ID of the maintenance window the target was removed from.
     * </p>
     * 
     * @return The ID of the maintenance window the target was removed from.
     */
    public final String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The ID of the removed target definition.
     * </p>
     * 
     * @return The ID of the removed target definition.
     */
    public final String windowTargetId() {
        return windowTargetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(windowTargetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterTargetFromMaintenanceWindowResponse)) {
            return false;
        }
        DeregisterTargetFromMaintenanceWindowResponse other = (DeregisterTargetFromMaintenanceWindowResponse) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(windowTargetId(), other.windowTargetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeregisterTargetFromMaintenanceWindowResponse").add("WindowId", windowId())
                .add("WindowTargetId", windowTargetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.ofNullable(clazz.cast(windowId()));
        case "WindowTargetId":
            return Optional.ofNullable(clazz.cast(windowTargetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeregisterTargetFromMaintenanceWindowResponse, T> g) {
        return obj -> g.apply((DeregisterTargetFromMaintenanceWindowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeregisterTargetFromMaintenanceWindowResponse> {
        /**
         * <p>
         * The ID of the maintenance window the target was removed from.
         * </p>
         * 
         * @param windowId
         *        The ID of the maintenance window the target was removed from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The ID of the removed target definition.
         * </p>
         * 
         * @param windowTargetId
         *        The ID of the removed target definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTargetId(String windowTargetId);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String windowId;

        private String windowTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterTargetFromMaintenanceWindowResponse model) {
            super(model);
            windowId(model.windowId);
            windowTargetId(model.windowTargetId);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTargetId() {
            return windowTargetId;
        }

        @Override
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        @Override
        public DeregisterTargetFromMaintenanceWindowResponse build() {
            return new DeregisterTargetFromMaintenanceWindowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
