/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssociationBatchResponse extends SsmResponse implements
        ToCopyableBuilder<CreateAssociationBatchResponse.Builder, CreateAssociationBatchResponse> {
    private static final SdkField<List<AssociationDescription>> SUCCESSFUL_FIELD = SdkField
            .<List<AssociationDescription>> builder(MarshallingType.LIST)
            .memberName("Successful")
            .getter(getter(CreateAssociationBatchResponse::successful))
            .setter(setter(Builder::successful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociationDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociationDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FailedCreateAssociation>> FAILED_FIELD = SdkField
            .<List<FailedCreateAssociation>> builder(MarshallingType.LIST)
            .memberName("Failed")
            .getter(getter(CreateAssociationBatchResponse::failed))
            .setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedCreateAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedCreateAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SUCCESSFUL_FIELD, FAILED_FIELD));

    private final List<AssociationDescription> successful;

    private final List<FailedCreateAssociation> failed;

    private CreateAssociationBatchResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    /**
     * Returns true if the Successful property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSuccessful() {
        return successful != null && !(successful instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the associations that succeeded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuccessful()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the associations that succeeded.
     */
    public final List<AssociationDescription> successful() {
        return successful;
    }

    /**
     * Returns true if the Failed property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFailed() {
        return failed != null && !(failed instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the associations that failed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailed()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the associations that failed.
     */
    public final List<FailedCreateAssociation> failed() {
        return failed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessful() ? successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailed() ? failed() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssociationBatchResponse)) {
            return false;
        }
        CreateAssociationBatchResponse other = (CreateAssociationBatchResponse) obj;
        return hasSuccessful() == other.hasSuccessful() && Objects.equals(successful(), other.successful())
                && hasFailed() == other.hasFailed() && Objects.equals(failed(), other.failed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAssociationBatchResponse").add("Successful", hasSuccessful() ? successful() : null)
                .add("Failed", hasFailed() ? failed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Successful":
            return Optional.ofNullable(clazz.cast(successful()));
        case "Failed":
            return Optional.ofNullable(clazz.cast(failed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssociationBatchResponse, T> g) {
        return obj -> g.apply((CreateAssociationBatchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAssociationBatchResponse> {
        /**
         * <p>
         * Information about the associations that succeeded.
         * </p>
         * 
         * @param successful
         *        Information about the associations that succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<AssociationDescription> successful);

        /**
         * <p>
         * Information about the associations that succeeded.
         * </p>
         * 
         * @param successful
         *        Information about the associations that succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(AssociationDescription... successful);

        /**
         * <p>
         * Information about the associations that succeeded.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssociationDescription>.Builder} avoiding
         * the need to create one manually via {@link List<AssociationDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssociationDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #successful(List<AssociationDescription>)}.
         * 
         * @param successful
         *        a consumer that will call methods on {@link List<AssociationDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successful(List<AssociationDescription>)
         */
        Builder successful(Consumer<AssociationDescription.Builder>... successful);

        /**
         * <p>
         * Information about the associations that failed.
         * </p>
         * 
         * @param failed
         *        Information about the associations that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Collection<FailedCreateAssociation> failed);

        /**
         * <p>
         * Information about the associations that failed.
         * </p>
         * 
         * @param failed
         *        Information about the associations that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(FailedCreateAssociation... failed);

        /**
         * <p>
         * Information about the associations that failed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FailedCreateAssociation>.Builder} avoiding
         * the need to create one manually via {@link List<FailedCreateAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FailedCreateAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link #failed(List<FailedCreateAssociation>)}.
         * 
         * @param failed
         *        a consumer that will call methods on {@link List<FailedCreateAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failed(List<FailedCreateAssociation>)
         */
        Builder failed(Consumer<FailedCreateAssociation.Builder>... failed);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<AssociationDescription> successful = DefaultSdkAutoConstructList.getInstance();

        private List<FailedCreateAssociation> failed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssociationBatchResponse model) {
            super(model);
            successful(model.successful);
            failed(model.failed);
        }

        public final List<AssociationDescription.Builder> getSuccessful() {
            List<AssociationDescription.Builder> result = AssociationDescriptionListCopier.copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder successful(Collection<AssociationDescription> successful) {
            this.successful = AssociationDescriptionListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(AssociationDescription... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<AssociationDescription.Builder>... successful) {
            successful(Stream.of(successful).map(c -> AssociationDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessful(Collection<AssociationDescription.BuilderImpl> successful) {
            this.successful = AssociationDescriptionListCopier.copyFromBuilder(successful);
        }

        public final List<FailedCreateAssociation.Builder> getFailed() {
            List<FailedCreateAssociation.Builder> result = FailedCreateAssociationListCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder failed(Collection<FailedCreateAssociation> failed) {
            this.failed = FailedCreateAssociationListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(FailedCreateAssociation... failed) {
            failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<FailedCreateAssociation.Builder>... failed) {
            failed(Stream.of(failed).map(c -> FailedCreateAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFailed(Collection<FailedCreateAssociation.BuilderImpl> failed) {
            this.failed = FailedCreateAssociationListCopier.copyFromBuilder(failed);
        }

        @Override
        public CreateAssociationBatchResponse build() {
            return new CreateAssociationBatchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
