/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.AssociationExecutionTarget;
import software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAssociationExecutionTargetsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeAssociationExecutionTargetsResponse> {
    private static final SdkField<List<AssociationExecutionTarget>> ASSOCIATION_EXECUTION_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociationExecutionTargets").getter(DescribeAssociationExecutionTargetsResponse.getter(DescribeAssociationExecutionTargetsResponse::associationExecutionTargets)).setter(DescribeAssociationExecutionTargetsResponse.setter(Builder::associationExecutionTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationExecutionTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociationExecutionTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAssociationExecutionTargetsResponse.getter(DescribeAssociationExecutionTargetsResponse::nextToken)).setter(DescribeAssociationExecutionTargetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_EXECUTION_TARGETS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AssociationExecutionTarget> associationExecutionTargets;
    private final String nextToken;

    private DescribeAssociationExecutionTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.associationExecutionTargets = builder.associationExecutionTargets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssociationExecutionTargets() {
        return this.associationExecutionTargets != null && !(this.associationExecutionTargets instanceof SdkAutoConstructList);
    }

    public final List<AssociationExecutionTarget> associationExecutionTargets() {
        return this.associationExecutionTargets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociationExecutionTargets() ? this.associationExecutionTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssociationExecutionTargetsResponse)) {
            return false;
        }
        DescribeAssociationExecutionTargetsResponse other = (DescribeAssociationExecutionTargetsResponse)((Object)obj);
        return this.hasAssociationExecutionTargets() == other.hasAssociationExecutionTargets() && Objects.equals(this.associationExecutionTargets(), other.associationExecutionTargets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAssociationExecutionTargetsResponse").add("AssociationExecutionTargets", this.hasAssociationExecutionTargets() ? this.associationExecutionTargets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationExecutionTargets": {
                return Optional.ofNullable(clazz.cast(this.associationExecutionTargets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssociationExecutionTargetsResponse, T> g) {
        return obj -> g.apply((DescribeAssociationExecutionTargetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<AssociationExecutionTarget> associationExecutionTargets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssociationExecutionTargetsResponse model) {
            super(model);
            this.associationExecutionTargets(model.associationExecutionTargets);
            this.nextToken(model.nextToken);
        }

        public final Collection<AssociationExecutionTarget.Builder> getAssociationExecutionTargets() {
            if (this.associationExecutionTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associationExecutionTargets != null ? (Collection)this.associationExecutionTargets.stream().map(AssociationExecutionTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associationExecutionTargets(Collection<AssociationExecutionTarget> associationExecutionTargets) {
            this.associationExecutionTargets = AssociationExecutionTargetsListCopier.copy(associationExecutionTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationExecutionTargets(AssociationExecutionTarget ... associationExecutionTargets) {
            this.associationExecutionTargets(Arrays.asList(associationExecutionTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationExecutionTargets(Consumer<AssociationExecutionTarget.Builder> ... associationExecutionTargets) {
            this.associationExecutionTargets(Stream.of(associationExecutionTargets).map(c -> (AssociationExecutionTarget)((AssociationExecutionTarget.Builder)AssociationExecutionTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssociationExecutionTargets(Collection<AssociationExecutionTarget.BuilderImpl> associationExecutionTargets) {
            this.associationExecutionTargets = AssociationExecutionTargetsListCopier.copyFromBuilder(associationExecutionTargets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAssociationExecutionTargetsResponse build() {
            return new DescribeAssociationExecutionTargetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAssociationExecutionTargetsResponse> {
        public Builder associationExecutionTargets(Collection<AssociationExecutionTarget> var1);

        public Builder associationExecutionTargets(AssociationExecutionTarget ... var1);

        public Builder associationExecutionTargets(Consumer<AssociationExecutionTarget.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

