/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMaintenanceWindowsForTargetResponse extends SsmResponse implements
        ToCopyableBuilder<DescribeMaintenanceWindowsForTargetResponse.Builder, DescribeMaintenanceWindowsForTargetResponse> {
    private static final SdkField<List<MaintenanceWindowIdentityForTarget>> WINDOW_IDENTITIES_FIELD = SdkField
            .<List<MaintenanceWindowIdentityForTarget>> builder(MarshallingType.LIST)
            .memberName("WindowIdentities")
            .getter(getter(DescribeMaintenanceWindowsForTargetResponse::windowIdentities))
            .setter(setter(Builder::windowIdentities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowIdentities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MaintenanceWindowIdentityForTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(MaintenanceWindowIdentityForTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeMaintenanceWindowsForTargetResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_IDENTITIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MaintenanceWindowIdentityForTarget> windowIdentities;

    private final String nextToken;

    private DescribeMaintenanceWindowsForTargetResponse(BuilderImpl builder) {
        super(builder);
        this.windowIdentities = builder.windowIdentities;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the WindowIdentities property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasWindowIdentities() {
        return windowIdentities != null && !(windowIdentities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the maintenance window targets and tasks an instance is associated with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWindowIdentities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the maintenance window targets and tasks an instance is associated with.
     */
    public final List<MaintenanceWindowIdentityForTarget> windowIdentities() {
        return windowIdentities;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You use this token in the next call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You use this token in the next call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWindowIdentities() ? windowIdentities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowsForTargetResponse)) {
            return false;
        }
        DescribeMaintenanceWindowsForTargetResponse other = (DescribeMaintenanceWindowsForTargetResponse) obj;
        return hasWindowIdentities() == other.hasWindowIdentities()
                && Objects.equals(windowIdentities(), other.windowIdentities()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMaintenanceWindowsForTargetResponse")
                .add("WindowIdentities", hasWindowIdentities() ? windowIdentities() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowIdentities":
            return Optional.ofNullable(clazz.cast(windowIdentities()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMaintenanceWindowsForTargetResponse, T> g) {
        return obj -> g.apply((DescribeMaintenanceWindowsForTargetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMaintenanceWindowsForTargetResponse> {
        /**
         * <p>
         * Information about the maintenance window targets and tasks an instance is associated with.
         * </p>
         * 
         * @param windowIdentities
         *        Information about the maintenance window targets and tasks an instance is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowIdentities(Collection<MaintenanceWindowIdentityForTarget> windowIdentities);

        /**
         * <p>
         * Information about the maintenance window targets and tasks an instance is associated with.
         * </p>
         * 
         * @param windowIdentities
         *        Information about the maintenance window targets and tasks an instance is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowIdentities(MaintenanceWindowIdentityForTarget... windowIdentities);

        /**
         * <p>
         * Information about the maintenance window targets and tasks an instance is associated with.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <MaintenanceWindowIdentityForTarget>.Builder} avoiding the need to create one manually via {@link List
         * <MaintenanceWindowIdentityForTarget>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MaintenanceWindowIdentityForTarget>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #windowIdentities(List<MaintenanceWindowIdentityForTarget>)}.
         * 
         * @param windowIdentities
         *        a consumer that will call methods on {@link List<MaintenanceWindowIdentityForTarget>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #windowIdentities(List<MaintenanceWindowIdentityForTarget>)
         */
        Builder windowIdentities(Consumer<MaintenanceWindowIdentityForTarget.Builder>... windowIdentities);

        /**
         * <p>
         * The token for the next set of items to return. (You use this token in the next call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You use this token in the next call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<MaintenanceWindowIdentityForTarget> windowIdentities = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowsForTargetResponse model) {
            super(model);
            windowIdentities(model.windowIdentities);
            nextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowIdentityForTarget.Builder> getWindowIdentities() {
            if (windowIdentities instanceof SdkAutoConstructList) {
                return null;
            }
            return windowIdentities != null ? windowIdentities.stream().map(MaintenanceWindowIdentityForTarget::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder windowIdentities(Collection<MaintenanceWindowIdentityForTarget> windowIdentities) {
            this.windowIdentities = MaintenanceWindowsForTargetListCopier.copy(windowIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowIdentities(MaintenanceWindowIdentityForTarget... windowIdentities) {
            windowIdentities(Arrays.asList(windowIdentities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowIdentities(Consumer<MaintenanceWindowIdentityForTarget.Builder>... windowIdentities) {
            windowIdentities(Stream.of(windowIdentities)
                    .map(c -> MaintenanceWindowIdentityForTarget.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWindowIdentities(Collection<MaintenanceWindowIdentityForTarget.BuilderImpl> windowIdentities) {
            this.windowIdentities = MaintenanceWindowsForTargetListCopier.copyFromBuilder(windowIdentities);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowsForTargetResponse build() {
            return new DescribeMaintenanceWindowsForTargetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
