/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.CloudWatchOutputConfig;
import software.amazon.awssdk.services.ssm.model.CommandInvocationStatus;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCommandInvocationResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, GetCommandInvocationResponse> {
    private static final SdkField<String> COMMAND_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CommandId").getter(GetCommandInvocationResponse.getter(GetCommandInvocationResponse::commandId)).setter(GetCommandInvocationResponse.setter(Builder::commandId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommandId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(GetCommandInvocationResponse.getter(GetCommandInvocationResponse::instanceId)).setter(GetCommandInvocationResponse.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(GetCommandInvocationResponse.getter(GetCommandInvocationResponse::comment)).setter(GetCommandInvocationResponse.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()}).build();
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentName").getter(GetCommandInvocationResponse.getter(GetCommandInvocationResponse::documentName)).setter(GetCommandInvocationResponse.setter(Builder::documentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(GetCommandInvocationResponse.getter(GetCommandInvocationResponse::documentVersion)).setter(GetCommandInvocationResponse.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<String> PLUGIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PluginName").getter(GetCommandInvocationResponse.getter(GetCommandInvocationResponse::pluginName)).setter(GetCommandInvocationResponse.setter(Builder::pluginName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginName").build()}).build();
    private static final SdkField<Integer> RESPONSE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ResponseCode").getter(GetCommandInvocationResponse.getter(GetCommandInvocationResponse::responseCode)).setter(GetCommandInvocationResponse.setter(Builder::responseCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseCode").build()}).build();
    private static final SdkField<String> EXECUTION_START_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionStartDateTime").getter(GetCommandInvocationResponse.getter(GetCommandInvocationResponse::executionStartDateTime)).setter(GetCommandInvocationResponse.setter(Builder::executionStartDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStartDateTime").build()}).build();
    private static final SdkField<String> EXECUTION_ELAPSED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionElapsedTime").getter(GetCommandInvocationResponse.getter(GetCommandInvocationResponse::executionElapsedTime)).setter(GetCommandInvocationResponse.setter(Builder::executionElapsedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionElapsedTime").build()}).build();
    private static final SdkField<String> EXECUTION_END_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionEndDateTime").getter(GetCommandInvocationResponse.getter(GetCommandInvocationResponse::executionEndDateTime)).setter(GetCommandInvocationResponse.setter(Builder::executionEndDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEndDateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetCommandInvocationResponse.getter(GetCommandInvocationResponse::statusAsString)).setter(GetCommandInvocationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusDetails").getter(GetCommandInvocationResponse.getter(GetCommandInvocationResponse::statusDetails)).setter(GetCommandInvocationResponse.setter(Builder::statusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build()}).build();
    private static final SdkField<String> STANDARD_OUTPUT_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardOutputContent").getter(GetCommandInvocationResponse.getter(GetCommandInvocationResponse::standardOutputContent)).setter(GetCommandInvocationResponse.setter(Builder::standardOutputContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardOutputContent").build()}).build();
    private static final SdkField<String> STANDARD_OUTPUT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardOutputUrl").getter(GetCommandInvocationResponse.getter(GetCommandInvocationResponse::standardOutputUrl)).setter(GetCommandInvocationResponse.setter(Builder::standardOutputUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardOutputUrl").build()}).build();
    private static final SdkField<String> STANDARD_ERROR_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardErrorContent").getter(GetCommandInvocationResponse.getter(GetCommandInvocationResponse::standardErrorContent)).setter(GetCommandInvocationResponse.setter(Builder::standardErrorContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardErrorContent").build()}).build();
    private static final SdkField<String> STANDARD_ERROR_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardErrorUrl").getter(GetCommandInvocationResponse.getter(GetCommandInvocationResponse::standardErrorUrl)).setter(GetCommandInvocationResponse.setter(Builder::standardErrorUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardErrorUrl").build()}).build();
    private static final SdkField<CloudWatchOutputConfig> CLOUD_WATCH_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchOutputConfig").getter(GetCommandInvocationResponse.getter(GetCommandInvocationResponse::cloudWatchOutputConfig)).setter(GetCommandInvocationResponse.setter(Builder::cloudWatchOutputConfig)).constructor(CloudWatchOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchOutputConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ID_FIELD, INSTANCE_ID_FIELD, COMMENT_FIELD, DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, PLUGIN_NAME_FIELD, RESPONSE_CODE_FIELD, EXECUTION_START_DATE_TIME_FIELD, EXECUTION_ELAPSED_TIME_FIELD, EXECUTION_END_DATE_TIME_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, STANDARD_OUTPUT_CONTENT_FIELD, STANDARD_OUTPUT_URL_FIELD, STANDARD_ERROR_CONTENT_FIELD, STANDARD_ERROR_URL_FIELD, CLOUD_WATCH_OUTPUT_CONFIG_FIELD));
    private final String commandId;
    private final String instanceId;
    private final String comment;
    private final String documentName;
    private final String documentVersion;
    private final String pluginName;
    private final Integer responseCode;
    private final String executionStartDateTime;
    private final String executionElapsedTime;
    private final String executionEndDateTime;
    private final String status;
    private final String statusDetails;
    private final String standardOutputContent;
    private final String standardOutputUrl;
    private final String standardErrorContent;
    private final String standardErrorUrl;
    private final CloudWatchOutputConfig cloudWatchOutputConfig;

    private GetCommandInvocationResponse(BuilderImpl builder) {
        super(builder);
        this.commandId = builder.commandId;
        this.instanceId = builder.instanceId;
        this.comment = builder.comment;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.pluginName = builder.pluginName;
        this.responseCode = builder.responseCode;
        this.executionStartDateTime = builder.executionStartDateTime;
        this.executionElapsedTime = builder.executionElapsedTime;
        this.executionEndDateTime = builder.executionEndDateTime;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.standardOutputContent = builder.standardOutputContent;
        this.standardOutputUrl = builder.standardOutputUrl;
        this.standardErrorContent = builder.standardErrorContent;
        this.standardErrorUrl = builder.standardErrorUrl;
        this.cloudWatchOutputConfig = builder.cloudWatchOutputConfig;
    }

    public final String commandId() {
        return this.commandId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String comment() {
        return this.comment;
    }

    public final String documentName() {
        return this.documentName;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final String pluginName() {
        return this.pluginName;
    }

    public final Integer responseCode() {
        return this.responseCode;
    }

    public final String executionStartDateTime() {
        return this.executionStartDateTime;
    }

    public final String executionElapsedTime() {
        return this.executionElapsedTime;
    }

    public final String executionEndDateTime() {
        return this.executionEndDateTime;
    }

    public final CommandInvocationStatus status() {
        return CommandInvocationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusDetails() {
        return this.statusDetails;
    }

    public final String standardOutputContent() {
        return this.standardOutputContent;
    }

    public final String standardOutputUrl() {
        return this.standardOutputUrl;
    }

    public final String standardErrorContent() {
        return this.standardErrorContent;
    }

    public final String standardErrorUrl() {
        return this.standardErrorUrl;
    }

    public final CloudWatchOutputConfig cloudWatchOutputConfig() {
        return this.cloudWatchOutputConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.commandId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginName());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionElapsedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEndDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardOutputContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardOutputUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardErrorContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardErrorUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchOutputConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommandInvocationResponse)) {
            return false;
        }
        GetCommandInvocationResponse other = (GetCommandInvocationResponse)((Object)obj);
        return Objects.equals(this.commandId(), other.commandId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.pluginName(), other.pluginName()) && Objects.equals(this.responseCode(), other.responseCode()) && Objects.equals(this.executionStartDateTime(), other.executionStartDateTime()) && Objects.equals(this.executionElapsedTime(), other.executionElapsedTime()) && Objects.equals(this.executionEndDateTime(), other.executionEndDateTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.standardOutputContent(), other.standardOutputContent()) && Objects.equals(this.standardOutputUrl(), other.standardOutputUrl()) && Objects.equals(this.standardErrorContent(), other.standardErrorContent()) && Objects.equals(this.standardErrorUrl(), other.standardErrorUrl()) && Objects.equals(this.cloudWatchOutputConfig(), other.cloudWatchOutputConfig());
    }

    public final String toString() {
        return ToString.builder((String)"GetCommandInvocationResponse").add("CommandId", (Object)this.commandId()).add("InstanceId", (Object)this.instanceId()).add("Comment", (Object)this.comment()).add("DocumentName", (Object)this.documentName()).add("DocumentVersion", (Object)this.documentVersion()).add("PluginName", (Object)this.pluginName()).add("ResponseCode", (Object)this.responseCode()).add("ExecutionStartDateTime", (Object)this.executionStartDateTime()).add("ExecutionElapsedTime", (Object)this.executionElapsedTime()).add("ExecutionEndDateTime", (Object)this.executionEndDateTime()).add("Status", (Object)this.statusAsString()).add("StatusDetails", (Object)this.statusDetails()).add("StandardOutputContent", (Object)this.standardOutputContent()).add("StandardOutputUrl", (Object)this.standardOutputUrl()).add("StandardErrorContent", (Object)this.standardErrorContent()).add("StandardErrorUrl", (Object)this.standardErrorUrl()).add("CloudWatchOutputConfig", (Object)this.cloudWatchOutputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CommandId": {
                return Optional.ofNullable(clazz.cast(this.commandId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "DocumentName": {
                return Optional.ofNullable(clazz.cast(this.documentName()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "PluginName": {
                return Optional.ofNullable(clazz.cast(this.pluginName()));
            }
            case "ResponseCode": {
                return Optional.ofNullable(clazz.cast(this.responseCode()));
            }
            case "ExecutionStartDateTime": {
                return Optional.ofNullable(clazz.cast(this.executionStartDateTime()));
            }
            case "ExecutionElapsedTime": {
                return Optional.ofNullable(clazz.cast(this.executionElapsedTime()));
            }
            case "ExecutionEndDateTime": {
                return Optional.ofNullable(clazz.cast(this.executionEndDateTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "StandardOutputContent": {
                return Optional.ofNullable(clazz.cast(this.standardOutputContent()));
            }
            case "StandardOutputUrl": {
                return Optional.ofNullable(clazz.cast(this.standardOutputUrl()));
            }
            case "StandardErrorContent": {
                return Optional.ofNullable(clazz.cast(this.standardErrorContent()));
            }
            case "StandardErrorUrl": {
                return Optional.ofNullable(clazz.cast(this.standardErrorUrl()));
            }
            case "CloudWatchOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchOutputConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCommandInvocationResponse, T> g) {
        return obj -> g.apply((GetCommandInvocationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String commandId;
        private String instanceId;
        private String comment;
        private String documentName;
        private String documentVersion;
        private String pluginName;
        private Integer responseCode;
        private String executionStartDateTime;
        private String executionElapsedTime;
        private String executionEndDateTime;
        private String status;
        private String statusDetails;
        private String standardOutputContent;
        private String standardOutputUrl;
        private String standardErrorContent;
        private String standardErrorUrl;
        private CloudWatchOutputConfig cloudWatchOutputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommandInvocationResponse model) {
            super(model);
            this.commandId(model.commandId);
            this.instanceId(model.instanceId);
            this.comment(model.comment);
            this.documentName(model.documentName);
            this.documentVersion(model.documentVersion);
            this.pluginName(model.pluginName);
            this.responseCode(model.responseCode);
            this.executionStartDateTime(model.executionStartDateTime);
            this.executionElapsedTime(model.executionElapsedTime);
            this.executionEndDateTime(model.executionEndDateTime);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.standardOutputContent(model.standardOutputContent);
            this.standardOutputUrl(model.standardOutputUrl);
            this.standardErrorContent(model.standardErrorContent);
            this.standardErrorUrl(model.standardErrorUrl);
            this.cloudWatchOutputConfig(model.cloudWatchOutputConfig);
        }

        public final String getCommandId() {
            return this.commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getPluginName() {
            return this.pluginName;
        }

        @Override
        public final Builder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public final void setPluginName(String pluginName) {
            this.pluginName = pluginName;
        }

        public final Integer getResponseCode() {
            return this.responseCode;
        }

        @Override
        public final Builder responseCode(Integer responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final void setResponseCode(Integer responseCode) {
            this.responseCode = responseCode;
        }

        public final String getExecutionStartDateTime() {
            return this.executionStartDateTime;
        }

        @Override
        public final Builder executionStartDateTime(String executionStartDateTime) {
            this.executionStartDateTime = executionStartDateTime;
            return this;
        }

        public final void setExecutionStartDateTime(String executionStartDateTime) {
            this.executionStartDateTime = executionStartDateTime;
        }

        public final String getExecutionElapsedTime() {
            return this.executionElapsedTime;
        }

        @Override
        public final Builder executionElapsedTime(String executionElapsedTime) {
            this.executionElapsedTime = executionElapsedTime;
            return this;
        }

        public final void setExecutionElapsedTime(String executionElapsedTime) {
            this.executionElapsedTime = executionElapsedTime;
        }

        public final String getExecutionEndDateTime() {
            return this.executionEndDateTime;
        }

        @Override
        public final Builder executionEndDateTime(String executionEndDateTime) {
            this.executionEndDateTime = executionEndDateTime;
            return this;
        }

        public final void setExecutionEndDateTime(String executionEndDateTime) {
            this.executionEndDateTime = executionEndDateTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommandInvocationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final String getStandardOutputContent() {
            return this.standardOutputContent;
        }

        @Override
        public final Builder standardOutputContent(String standardOutputContent) {
            this.standardOutputContent = standardOutputContent;
            return this;
        }

        public final void setStandardOutputContent(String standardOutputContent) {
            this.standardOutputContent = standardOutputContent;
        }

        public final String getStandardOutputUrl() {
            return this.standardOutputUrl;
        }

        @Override
        public final Builder standardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
            return this;
        }

        public final void setStandardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
        }

        public final String getStandardErrorContent() {
            return this.standardErrorContent;
        }

        @Override
        public final Builder standardErrorContent(String standardErrorContent) {
            this.standardErrorContent = standardErrorContent;
            return this;
        }

        public final void setStandardErrorContent(String standardErrorContent) {
            this.standardErrorContent = standardErrorContent;
        }

        public final String getStandardErrorUrl() {
            return this.standardErrorUrl;
        }

        @Override
        public final Builder standardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
            return this;
        }

        public final void setStandardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
        }

        public final CloudWatchOutputConfig.Builder getCloudWatchOutputConfig() {
            return this.cloudWatchOutputConfig != null ? this.cloudWatchOutputConfig.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchOutputConfig(CloudWatchOutputConfig cloudWatchOutputConfig) {
            this.cloudWatchOutputConfig = cloudWatchOutputConfig;
            return this;
        }

        public final void setCloudWatchOutputConfig(CloudWatchOutputConfig.BuilderImpl cloudWatchOutputConfig) {
            this.cloudWatchOutputConfig = cloudWatchOutputConfig != null ? cloudWatchOutputConfig.build() : null;
        }

        @Override
        public GetCommandInvocationResponse build() {
            return new GetCommandInvocationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCommandInvocationResponse> {
        public Builder commandId(String var1);

        public Builder instanceId(String var1);

        public Builder comment(String var1);

        public Builder documentName(String var1);

        public Builder documentVersion(String var1);

        public Builder pluginName(String var1);

        public Builder responseCode(Integer var1);

        public Builder executionStartDateTime(String var1);

        public Builder executionElapsedTime(String var1);

        public Builder executionEndDateTime(String var1);

        public Builder status(String var1);

        public Builder status(CommandInvocationStatus var1);

        public Builder statusDetails(String var1);

        public Builder standardOutputContent(String var1);

        public Builder standardOutputUrl(String var1);

        public Builder standardErrorContent(String var1);

        public Builder standardErrorUrl(String var1);

        public Builder cloudWatchOutputConfig(CloudWatchOutputConfig var1);

        default public Builder cloudWatchOutputConfig(Consumer<CloudWatchOutputConfig.Builder> cloudWatchOutputConfig) {
            return this.cloudWatchOutputConfig((CloudWatchOutputConfig)((CloudWatchOutputConfig.Builder)CloudWatchOutputConfig.builder().applyMutation(cloudWatchOutputConfig)).build());
        }
    }
}

