/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.DocumentPermissionType;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDocumentPermissionRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, DescribeDocumentPermissionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeDocumentPermissionRequest.getter(DescribeDocumentPermissionRequest::name)).setter(DescribeDocumentPermissionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PERMISSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionType").getter(DescribeDocumentPermissionRequest.getter(DescribeDocumentPermissionRequest::permissionTypeAsString)).setter(DescribeDocumentPermissionRequest.setter(Builder::permissionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PERMISSION_TYPE_FIELD));
    private final String name;
    private final String permissionType;

    private DescribeDocumentPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.permissionType = builder.permissionType;
    }

    public final String name() {
        return this.name;
    }

    public final DocumentPermissionType permissionType() {
        return DocumentPermissionType.fromValue(this.permissionType);
    }

    public final String permissionTypeAsString() {
        return this.permissionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentPermissionRequest)) {
            return false;
        }
        DescribeDocumentPermissionRequest other = (DescribeDocumentPermissionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.permissionTypeAsString(), other.permissionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDocumentPermissionRequest").add("Name", (Object)this.name()).add("PermissionType", (Object)this.permissionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PermissionType": {
                return Optional.ofNullable(clazz.cast(this.permissionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDocumentPermissionRequest, T> g) {
        return obj -> g.apply((DescribeDocumentPermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String name;
        private String permissionType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentPermissionRequest model) {
            super(model);
            this.name(model.name);
            this.permissionType(model.permissionType);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPermissionType() {
            return this.permissionType;
        }

        @Override
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        public final Builder permissionType(DocumentPermissionType permissionType) {
            this.permissionType(permissionType == null ? null : permissionType.toString());
            return this;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDocumentPermissionRequest build() {
            return new DescribeDocumentPermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDocumentPermissionRequest> {
        public Builder name(String var1);

        public Builder permissionType(String var1);

        public Builder permissionType(DocumentPermissionType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

