/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDocumentsRequest extends SsmRequest implements
        ToCopyableBuilder<ListDocumentsRequest.Builder, ListDocumentsRequest> {
    private static final SdkField<List<DocumentFilter>> DOCUMENT_FILTER_LIST_FIELD = SdkField
            .<List<DocumentFilter>> builder(MarshallingType.LIST)
            .memberName("DocumentFilterList")
            .getter(getter(ListDocumentsRequest::documentFilterList))
            .setter(setter(Builder::documentFilterList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentFilterList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DocumentKeyValuesFilter>> FILTERS_FIELD = SdkField
            .<List<DocumentKeyValuesFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListDocumentsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentKeyValuesFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentKeyValuesFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListDocumentsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDocumentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FILTER_LIST_FIELD,
            FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<DocumentFilter> documentFilterList;

    private final List<DocumentKeyValuesFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private ListDocumentsRequest(BuilderImpl builder) {
        super(builder);
        this.documentFilterList = builder.documentFilterList;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DocumentFilterList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDocumentFilterList() {
        return documentFilterList != null && !(documentFilterList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This data type is deprecated. Instead, use <code>Filters</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDocumentFilterList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return This data type is deprecated. Instead, use <code>Filters</code>.
     */
    public final List<DocumentFilter> documentFilterList() {
        return documentFilterList;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more DocumentKeyValuesFilter objects. Use a filter to return a more specific list of results. For keys,
     * you can specify one or more key-value pair tags that have been applied to a document. Other valid keys include
     * <code>Owner</code>, <code>Name</code>, <code>PlatformTypes</code>, <code>DocumentType</code>, and
     * <code>TargetType</code>. For example, to return documents you own use <code>Key=Owner,Values=Self</code>. To
     * specify a custom key-value pair, use the format <code>Key=tag:tagName,Values=valueName</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more DocumentKeyValuesFilter objects. Use a filter to return a more specific list of results. For
     *         keys, you can specify one or more key-value pair tags that have been applied to a document. Other valid
     *         keys include <code>Owner</code>, <code>Name</code>, <code>PlatformTypes</code>, <code>DocumentType</code>
     *         , and <code>TargetType</code>. For example, to return documents you own use
     *         <code>Key=Owner,Values=Self</code>. To specify a custom key-value pair, use the format
     *         <code>Key=tag:tagName,Values=valueName</code>.
     */
    public final List<DocumentKeyValuesFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDocumentFilterList() ? documentFilterList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentsRequest)) {
            return false;
        }
        ListDocumentsRequest other = (ListDocumentsRequest) obj;
        return hasDocumentFilterList() == other.hasDocumentFilterList()
                && Objects.equals(documentFilterList(), other.documentFilterList()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDocumentsRequest")
                .add("DocumentFilterList", hasDocumentFilterList() ? documentFilterList() : null)
                .add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentFilterList":
            return Optional.ofNullable(clazz.cast(documentFilterList()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDocumentsRequest, T> g) {
        return obj -> g.apply((ListDocumentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDocumentsRequest> {
        /**
         * <p>
         * This data type is deprecated. Instead, use <code>Filters</code>.
         * </p>
         * 
         * @param documentFilterList
         *        This data type is deprecated. Instead, use <code>Filters</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentFilterList(Collection<DocumentFilter> documentFilterList);

        /**
         * <p>
         * This data type is deprecated. Instead, use <code>Filters</code>.
         * </p>
         * 
         * @param documentFilterList
         *        This data type is deprecated. Instead, use <code>Filters</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentFilterList(DocumentFilter... documentFilterList);

        /**
         * <p>
         * This data type is deprecated. Instead, use <code>Filters</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DocumentFilter>.Builder} avoiding the need
         * to create one manually via {@link List<DocumentFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #documentFilterList(List<DocumentFilter>)}.
         * 
         * @param documentFilterList
         *        a consumer that will call methods on {@link List<DocumentFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentFilterList(List<DocumentFilter>)
         */
        Builder documentFilterList(Consumer<DocumentFilter.Builder>... documentFilterList);

        /**
         * <p>
         * One or more DocumentKeyValuesFilter objects. Use a filter to return a more specific list of results. For
         * keys, you can specify one or more key-value pair tags that have been applied to a document. Other valid keys
         * include <code>Owner</code>, <code>Name</code>, <code>PlatformTypes</code>, <code>DocumentType</code>, and
         * <code>TargetType</code>. For example, to return documents you own use <code>Key=Owner,Values=Self</code>. To
         * specify a custom key-value pair, use the format <code>Key=tag:tagName,Values=valueName</code>.
         * </p>
         * 
         * @param filters
         *        One or more DocumentKeyValuesFilter objects. Use a filter to return a more specific list of results.
         *        For keys, you can specify one or more key-value pair tags that have been applied to a document. Other
         *        valid keys include <code>Owner</code>, <code>Name</code>, <code>PlatformTypes</code>,
         *        <code>DocumentType</code>, and <code>TargetType</code>. For example, to return documents you own use
         *        <code>Key=Owner,Values=Self</code>. To specify a custom key-value pair, use the format
         *        <code>Key=tag:tagName,Values=valueName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<DocumentKeyValuesFilter> filters);

        /**
         * <p>
         * One or more DocumentKeyValuesFilter objects. Use a filter to return a more specific list of results. For
         * keys, you can specify one or more key-value pair tags that have been applied to a document. Other valid keys
         * include <code>Owner</code>, <code>Name</code>, <code>PlatformTypes</code>, <code>DocumentType</code>, and
         * <code>TargetType</code>. For example, to return documents you own use <code>Key=Owner,Values=Self</code>. To
         * specify a custom key-value pair, use the format <code>Key=tag:tagName,Values=valueName</code>.
         * </p>
         * 
         * @param filters
         *        One or more DocumentKeyValuesFilter objects. Use a filter to return a more specific list of results.
         *        For keys, you can specify one or more key-value pair tags that have been applied to a document. Other
         *        valid keys include <code>Owner</code>, <code>Name</code>, <code>PlatformTypes</code>,
         *        <code>DocumentType</code>, and <code>TargetType</code>. For example, to return documents you own use
         *        <code>Key=Owner,Values=Self</code>. To specify a custom key-value pair, use the format
         *        <code>Key=tag:tagName,Values=valueName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(DocumentKeyValuesFilter... filters);

        /**
         * <p>
         * One or more DocumentKeyValuesFilter objects. Use a filter to return a more specific list of results. For
         * keys, you can specify one or more key-value pair tags that have been applied to a document. Other valid keys
         * include <code>Owner</code>, <code>Name</code>, <code>PlatformTypes</code>, <code>DocumentType</code>, and
         * <code>TargetType</code>. For example, to return documents you own use <code>Key=Owner,Values=Self</code>. To
         * specify a custom key-value pair, use the format <code>Key=tag:tagName,Values=valueName</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DocumentKeyValuesFilter>.Builder} avoiding
         * the need to create one manually via {@link List<DocumentKeyValuesFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentKeyValuesFilter>.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<DocumentKeyValuesFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<DocumentKeyValuesFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<DocumentKeyValuesFilter>)
         */
        Builder filters(Consumer<DocumentKeyValuesFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private List<DocumentFilter> documentFilterList = DefaultSdkAutoConstructList.getInstance();

        private List<DocumentKeyValuesFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentsRequest model) {
            super(model);
            documentFilterList(model.documentFilterList);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<DocumentFilter.Builder> getDocumentFilterList() {
            if (documentFilterList instanceof SdkAutoConstructList) {
                return null;
            }
            return documentFilterList != null ? documentFilterList.stream().map(DocumentFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentFilterList(Collection<DocumentFilter> documentFilterList) {
            this.documentFilterList = DocumentFilterListCopier.copy(documentFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentFilterList(DocumentFilter... documentFilterList) {
            documentFilterList(Arrays.asList(documentFilterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentFilterList(Consumer<DocumentFilter.Builder>... documentFilterList) {
            documentFilterList(Stream.of(documentFilterList).map(c -> DocumentFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDocumentFilterList(Collection<DocumentFilter.BuilderImpl> documentFilterList) {
            this.documentFilterList = DocumentFilterListCopier.copyFromBuilder(documentFilterList);
        }

        public final Collection<DocumentKeyValuesFilter.Builder> getFilters() {
            if (filters instanceof SdkAutoConstructList) {
                return null;
            }
            return filters != null ? filters.stream().map(DocumentKeyValuesFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<DocumentKeyValuesFilter> filters) {
            this.filters = DocumentKeyValuesFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(DocumentKeyValuesFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<DocumentKeyValuesFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> DocumentKeyValuesFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<DocumentKeyValuesFilter.BuilderImpl> filters) {
            this.filters = DocumentKeyValuesFilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDocumentsRequest build() {
            return new ListDocumentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
