/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePatchPropertiesResponse extends SsmResponse implements
        ToCopyableBuilder<DescribePatchPropertiesResponse.Builder, DescribePatchPropertiesResponse> {
    private static final SdkField<List<Map<String, String>>> PROPERTIES_FIELD = SdkField
            .<List<Map<String, String>>> builder(MarshallingType.LIST)
            .memberName("Properties")
            .getter(getter(DescribePatchPropertiesResponse::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribePatchPropertiesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Map<String, String>> properties;

    private final String nextToken;

    private DescribePatchPropertiesResponse(BuilderImpl builder) {
        super(builder);
        this.properties = builder.properties;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Properties property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the properties for patches matching the filter request parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProperties()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the properties for patches matching the filter request parameters.
     */
    public final List<Map<String, String>> properties() {
        return properties;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You use this token in the next call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You use this token in the next call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchPropertiesResponse)) {
            return false;
        }
        DescribePatchPropertiesResponse other = (DescribePatchPropertiesResponse) obj;
        return hasProperties() == other.hasProperties() && Objects.equals(properties(), other.properties())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePatchPropertiesResponse").add("Properties", hasProperties() ? properties() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePatchPropertiesResponse, T> g) {
        return obj -> g.apply((DescribePatchPropertiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePatchPropertiesResponse> {
        /**
         * <p>
         * A list of the properties for patches matching the filter request parameters.
         * </p>
         * 
         * @param properties
         *        A list of the properties for patches matching the filter request parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Collection<? extends Map<String, String>> properties);

        /**
         * <p>
         * A list of the properties for patches matching the filter request parameters.
         * </p>
         * 
         * @param properties
         *        A list of the properties for patches matching the filter request parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Map<String, String>... properties);

        /**
         * <p>
         * The token for the next set of items to return. (You use this token in the next call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You use this token in the next call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<Map<String, String>> properties = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchPropertiesResponse model) {
            super(model);
            properties(model.properties);
            nextToken(model.nextToken);
        }

        public final Collection<? extends Map<String, String>> getProperties() {
            if (properties instanceof SdkAutoConstructList) {
                return null;
            }
            return properties;
        }

        @Override
        public final Builder properties(Collection<? extends Map<String, String>> properties) {
            this.properties = PatchPropertiesListCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(Map<String, String>... properties) {
            properties(Arrays.asList(properties));
            return this;
        }

        public final void setProperties(Collection<? extends Map<String, String>> properties) {
            this.properties = PatchPropertiesListCopier.copy(properties);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribePatchPropertiesResponse build() {
            return new DescribePatchPropertiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
