/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.DocumentIdentifier;
import software.amazon.awssdk.services.ssm.model.DocumentIdentifierListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDocumentsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, ListDocumentsResponse> {
    private static final SdkField<List<DocumentIdentifier>> DOCUMENT_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentIdentifiers").getter(ListDocumentsResponse.getter(ListDocumentsResponse::documentIdentifiers)).setter(ListDocumentsResponse.setter(Builder::documentIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDocumentsResponse.getter(ListDocumentsResponse::nextToken)).setter(ListDocumentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_IDENTIFIERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DocumentIdentifier> documentIdentifiers;
    private final String nextToken;

    private ListDocumentsResponse(BuilderImpl builder) {
        super(builder);
        this.documentIdentifiers = builder.documentIdentifiers;
        this.nextToken = builder.nextToken;
    }

    public boolean hasDocumentIdentifiers() {
        return this.documentIdentifiers != null && !(this.documentIdentifiers instanceof SdkAutoConstructList);
    }

    public List<DocumentIdentifier> documentIdentifiers() {
        return this.documentIdentifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.documentIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentsResponse)) {
            return false;
        }
        ListDocumentsResponse other = (ListDocumentsResponse)((Object)obj);
        return Objects.equals(this.documentIdentifiers(), other.documentIdentifiers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDocumentsResponse").add("DocumentIdentifiers", this.documentIdentifiers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.documentIdentifiers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDocumentsResponse, T> g) {
        return obj -> g.apply((ListDocumentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<DocumentIdentifier> documentIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentsResponse model) {
            super(model);
            this.documentIdentifiers(model.documentIdentifiers);
            this.nextToken(model.nextToken);
        }

        public final Collection<DocumentIdentifier.Builder> getDocumentIdentifiers() {
            return this.documentIdentifiers != null ? (Collection)this.documentIdentifiers.stream().map(DocumentIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentIdentifiers(Collection<DocumentIdentifier> documentIdentifiers) {
            this.documentIdentifiers = DocumentIdentifierListCopier.copy(documentIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentIdentifiers(DocumentIdentifier ... documentIdentifiers) {
            this.documentIdentifiers(Arrays.asList(documentIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentIdentifiers(Consumer<DocumentIdentifier.Builder> ... documentIdentifiers) {
            this.documentIdentifiers(Stream.of(documentIdentifiers).map(c -> (DocumentIdentifier)((DocumentIdentifier.Builder)DocumentIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDocumentIdentifiers(Collection<DocumentIdentifier.BuilderImpl> documentIdentifiers) {
            this.documentIdentifiers = DocumentIdentifierListCopier.copyFromBuilder(documentIdentifiers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDocumentsResponse build() {
            return new ListDocumentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDocumentsResponse> {
        public Builder documentIdentifiers(Collection<DocumentIdentifier> var1);

        public Builder documentIdentifiers(DocumentIdentifier ... var1);

        public Builder documentIdentifiers(Consumer<DocumentIdentifier.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

