/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.CloudWatchOutputConfig;
import software.amazon.awssdk.services.ssm.model.CommandInvocationStatus;
import software.amazon.awssdk.services.ssm.model.CommandPlugin;
import software.amazon.awssdk.services.ssm.model.CommandPluginListCopier;
import software.amazon.awssdk.services.ssm.model.NotificationConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommandInvocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommandInvocation> {
    private static final SdkField<String> COMMAND_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CommandId").getter(CommandInvocation.getter(CommandInvocation::commandId)).setter(CommandInvocation.setter(Builder::commandId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommandId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(CommandInvocation.getter(CommandInvocation::instanceId)).setter(CommandInvocation.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceName").getter(CommandInvocation.getter(CommandInvocation::instanceName)).setter(CommandInvocation.setter(Builder::instanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceName").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(CommandInvocation.getter(CommandInvocation::comment)).setter(CommandInvocation.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()}).build();
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentName").getter(CommandInvocation.getter(CommandInvocation::documentName)).setter(CommandInvocation.setter(Builder::documentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(CommandInvocation.getter(CommandInvocation::documentVersion)).setter(CommandInvocation.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<Instant> REQUESTED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RequestedDateTime").getter(CommandInvocation.getter(CommandInvocation::requestedDateTime)).setter(CommandInvocation.setter(Builder::requestedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedDateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CommandInvocation.getter(CommandInvocation::statusAsString)).setter(CommandInvocation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusDetails").getter(CommandInvocation.getter(CommandInvocation::statusDetails)).setter(CommandInvocation.setter(Builder::statusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build()}).build();
    private static final SdkField<String> TRACE_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TraceOutput").getter(CommandInvocation.getter(CommandInvocation::traceOutput)).setter(CommandInvocation.setter(Builder::traceOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceOutput").build()}).build();
    private static final SdkField<String> STANDARD_OUTPUT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardOutputUrl").getter(CommandInvocation.getter(CommandInvocation::standardOutputUrl)).setter(CommandInvocation.setter(Builder::standardOutputUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardOutputUrl").build()}).build();
    private static final SdkField<String> STANDARD_ERROR_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardErrorUrl").getter(CommandInvocation.getter(CommandInvocation::standardErrorUrl)).setter(CommandInvocation.setter(Builder::standardErrorUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardErrorUrl").build()}).build();
    private static final SdkField<List<CommandPlugin>> COMMAND_PLUGINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CommandPlugins").getter(CommandInvocation.getter(CommandInvocation::commandPlugins)).setter(CommandInvocation.setter(Builder::commandPlugins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommandPlugins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CommandPlugin::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRole").getter(CommandInvocation.getter(CommandInvocation::serviceRole)).setter(CommandInvocation.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()}).build();
    private static final SdkField<NotificationConfig> NOTIFICATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationConfig").getter(CommandInvocation.getter(CommandInvocation::notificationConfig)).setter(CommandInvocation.setter(Builder::notificationConfig)).constructor(NotificationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfig").build()}).build();
    private static final SdkField<CloudWatchOutputConfig> CLOUD_WATCH_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchOutputConfig").getter(CommandInvocation.getter(CommandInvocation::cloudWatchOutputConfig)).setter(CommandInvocation.setter(Builder::cloudWatchOutputConfig)).constructor(CloudWatchOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchOutputConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ID_FIELD, INSTANCE_ID_FIELD, INSTANCE_NAME_FIELD, COMMENT_FIELD, DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, REQUESTED_DATE_TIME_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, TRACE_OUTPUT_FIELD, STANDARD_OUTPUT_URL_FIELD, STANDARD_ERROR_URL_FIELD, COMMAND_PLUGINS_FIELD, SERVICE_ROLE_FIELD, NOTIFICATION_CONFIG_FIELD, CLOUD_WATCH_OUTPUT_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String commandId;
    private final String instanceId;
    private final String instanceName;
    private final String comment;
    private final String documentName;
    private final String documentVersion;
    private final Instant requestedDateTime;
    private final String status;
    private final String statusDetails;
    private final String traceOutput;
    private final String standardOutputUrl;
    private final String standardErrorUrl;
    private final List<CommandPlugin> commandPlugins;
    private final String serviceRole;
    private final NotificationConfig notificationConfig;
    private final CloudWatchOutputConfig cloudWatchOutputConfig;

    private CommandInvocation(BuilderImpl builder) {
        this.commandId = builder.commandId;
        this.instanceId = builder.instanceId;
        this.instanceName = builder.instanceName;
        this.comment = builder.comment;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.requestedDateTime = builder.requestedDateTime;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.traceOutput = builder.traceOutput;
        this.standardOutputUrl = builder.standardOutputUrl;
        this.standardErrorUrl = builder.standardErrorUrl;
        this.commandPlugins = builder.commandPlugins;
        this.serviceRole = builder.serviceRole;
        this.notificationConfig = builder.notificationConfig;
        this.cloudWatchOutputConfig = builder.cloudWatchOutputConfig;
    }

    public String commandId() {
        return this.commandId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public String comment() {
        return this.comment;
    }

    public String documentName() {
        return this.documentName;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public Instant requestedDateTime() {
        return this.requestedDateTime;
    }

    public CommandInvocationStatus status() {
        return CommandInvocationStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public String traceOutput() {
        return this.traceOutput;
    }

    public String standardOutputUrl() {
        return this.standardOutputUrl;
    }

    public String standardErrorUrl() {
        return this.standardErrorUrl;
    }

    public boolean hasCommandPlugins() {
        return this.commandPlugins != null && !(this.commandPlugins instanceof SdkAutoConstructList);
    }

    public List<CommandPlugin> commandPlugins() {
        return this.commandPlugins;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public NotificationConfig notificationConfig() {
        return this.notificationConfig;
    }

    public CloudWatchOutputConfig cloudWatchOutputConfig() {
        return this.cloudWatchOutputConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commandId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardOutputUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardErrorUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.commandPlugins());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchOutputConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandInvocation)) {
            return false;
        }
        CommandInvocation other = (CommandInvocation)obj;
        return Objects.equals(this.commandId(), other.commandId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.requestedDateTime(), other.requestedDateTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.traceOutput(), other.traceOutput()) && Objects.equals(this.standardOutputUrl(), other.standardOutputUrl()) && Objects.equals(this.standardErrorUrl(), other.standardErrorUrl()) && Objects.equals(this.commandPlugins(), other.commandPlugins()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.notificationConfig(), other.notificationConfig()) && Objects.equals(this.cloudWatchOutputConfig(), other.cloudWatchOutputConfig());
    }

    public String toString() {
        return ToString.builder((String)"CommandInvocation").add("CommandId", (Object)this.commandId()).add("InstanceId", (Object)this.instanceId()).add("InstanceName", (Object)this.instanceName()).add("Comment", (Object)this.comment()).add("DocumentName", (Object)this.documentName()).add("DocumentVersion", (Object)this.documentVersion()).add("RequestedDateTime", (Object)this.requestedDateTime()).add("Status", (Object)this.statusAsString()).add("StatusDetails", (Object)this.statusDetails()).add("TraceOutput", (Object)this.traceOutput()).add("StandardOutputUrl", (Object)this.standardOutputUrl()).add("StandardErrorUrl", (Object)this.standardErrorUrl()).add("CommandPlugins", this.commandPlugins()).add("ServiceRole", (Object)this.serviceRole()).add("NotificationConfig", (Object)this.notificationConfig()).add("CloudWatchOutputConfig", (Object)this.cloudWatchOutputConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CommandId": {
                return Optional.ofNullable(clazz.cast(this.commandId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "DocumentName": {
                return Optional.ofNullable(clazz.cast(this.documentName()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "RequestedDateTime": {
                return Optional.ofNullable(clazz.cast(this.requestedDateTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "TraceOutput": {
                return Optional.ofNullable(clazz.cast(this.traceOutput()));
            }
            case "StandardOutputUrl": {
                return Optional.ofNullable(clazz.cast(this.standardOutputUrl()));
            }
            case "StandardErrorUrl": {
                return Optional.ofNullable(clazz.cast(this.standardErrorUrl()));
            }
            case "CommandPlugins": {
                return Optional.ofNullable(clazz.cast(this.commandPlugins()));
            }
            case "ServiceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "NotificationConfig": {
                return Optional.ofNullable(clazz.cast(this.notificationConfig()));
            }
            case "CloudWatchOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchOutputConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CommandInvocation, T> g) {
        return obj -> g.apply((CommandInvocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String commandId;
        private String instanceId;
        private String instanceName;
        private String comment;
        private String documentName;
        private String documentVersion;
        private Instant requestedDateTime;
        private String status;
        private String statusDetails;
        private String traceOutput;
        private String standardOutputUrl;
        private String standardErrorUrl;
        private List<CommandPlugin> commandPlugins = DefaultSdkAutoConstructList.getInstance();
        private String serviceRole;
        private NotificationConfig notificationConfig;
        private CloudWatchOutputConfig cloudWatchOutputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CommandInvocation model) {
            this.commandId(model.commandId);
            this.instanceId(model.instanceId);
            this.instanceName(model.instanceName);
            this.comment(model.comment);
            this.documentName(model.documentName);
            this.documentVersion(model.documentVersion);
            this.requestedDateTime(model.requestedDateTime);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.traceOutput(model.traceOutput);
            this.standardOutputUrl(model.standardOutputUrl);
            this.standardErrorUrl(model.standardErrorUrl);
            this.commandPlugins(model.commandPlugins);
            this.serviceRole(model.serviceRole);
            this.notificationConfig(model.notificationConfig);
            this.cloudWatchOutputConfig(model.cloudWatchOutputConfig);
        }

        public final String getCommandId() {
            return this.commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Instant getRequestedDateTime() {
            return this.requestedDateTime;
        }

        @Override
        public final Builder requestedDateTime(Instant requestedDateTime) {
            this.requestedDateTime = requestedDateTime;
            return this;
        }

        public final void setRequestedDateTime(Instant requestedDateTime) {
            this.requestedDateTime = requestedDateTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommandInvocationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final String getTraceOutput() {
            return this.traceOutput;
        }

        @Override
        public final Builder traceOutput(String traceOutput) {
            this.traceOutput = traceOutput;
            return this;
        }

        public final void setTraceOutput(String traceOutput) {
            this.traceOutput = traceOutput;
        }

        public final String getStandardOutputUrl() {
            return this.standardOutputUrl;
        }

        @Override
        public final Builder standardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
            return this;
        }

        public final void setStandardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
        }

        public final String getStandardErrorUrl() {
            return this.standardErrorUrl;
        }

        @Override
        public final Builder standardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
            return this;
        }

        public final void setStandardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
        }

        public final Collection<CommandPlugin.Builder> getCommandPlugins() {
            return this.commandPlugins != null ? (Collection)this.commandPlugins.stream().map(CommandPlugin::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder commandPlugins(Collection<CommandPlugin> commandPlugins) {
            this.commandPlugins = CommandPluginListCopier.copy(commandPlugins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandPlugins(CommandPlugin ... commandPlugins) {
            this.commandPlugins(Arrays.asList(commandPlugins));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandPlugins(Consumer<CommandPlugin.Builder> ... commandPlugins) {
            this.commandPlugins(Stream.of(commandPlugins).map(c -> (CommandPlugin)((CommandPlugin.Builder)CommandPlugin.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCommandPlugins(Collection<CommandPlugin.BuilderImpl> commandPlugins) {
            this.commandPlugins = CommandPluginListCopier.copyFromBuilder(commandPlugins);
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final NotificationConfig.Builder getNotificationConfig() {
            return this.notificationConfig != null ? this.notificationConfig.toBuilder() : null;
        }

        @Override
        public final Builder notificationConfig(NotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public final void setNotificationConfig(NotificationConfig.BuilderImpl notificationConfig) {
            this.notificationConfig = notificationConfig != null ? notificationConfig.build() : null;
        }

        public final CloudWatchOutputConfig.Builder getCloudWatchOutputConfig() {
            return this.cloudWatchOutputConfig != null ? this.cloudWatchOutputConfig.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchOutputConfig(CloudWatchOutputConfig cloudWatchOutputConfig) {
            this.cloudWatchOutputConfig = cloudWatchOutputConfig;
            return this;
        }

        public final void setCloudWatchOutputConfig(CloudWatchOutputConfig.BuilderImpl cloudWatchOutputConfig) {
            this.cloudWatchOutputConfig = cloudWatchOutputConfig != null ? cloudWatchOutputConfig.build() : null;
        }

        public CommandInvocation build() {
            return new CommandInvocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommandInvocation> {
        public Builder commandId(String var1);

        public Builder instanceId(String var1);

        public Builder instanceName(String var1);

        public Builder comment(String var1);

        public Builder documentName(String var1);

        public Builder documentVersion(String var1);

        public Builder requestedDateTime(Instant var1);

        public Builder status(String var1);

        public Builder status(CommandInvocationStatus var1);

        public Builder statusDetails(String var1);

        public Builder traceOutput(String var1);

        public Builder standardOutputUrl(String var1);

        public Builder standardErrorUrl(String var1);

        public Builder commandPlugins(Collection<CommandPlugin> var1);

        public Builder commandPlugins(CommandPlugin ... var1);

        public Builder commandPlugins(Consumer<CommandPlugin.Builder> ... var1);

        public Builder serviceRole(String var1);

        public Builder notificationConfig(NotificationConfig var1);

        default public Builder notificationConfig(Consumer<NotificationConfig.Builder> notificationConfig) {
            return this.notificationConfig((NotificationConfig)((NotificationConfig.Builder)NotificationConfig.builder().applyMutation(notificationConfig)).build());
        }

        public Builder cloudWatchOutputConfig(CloudWatchOutputConfig var1);

        default public Builder cloudWatchOutputConfig(Consumer<CloudWatchOutputConfig.Builder> cloudWatchOutputConfig) {
            return this.cloudWatchOutputConfig((CloudWatchOutputConfig)((CloudWatchOutputConfig.Builder)CloudWatchOutputConfig.builder().applyMutation(cloudWatchOutputConfig)).build());
        }
    }
}

