/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A user-defined set of one or more filters on which to aggregate inventory data. Groups return a count of resources
 * that match and don't match the specified criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InventoryGroup implements SdkPojo, Serializable, ToCopyableBuilder<InventoryGroup.Builder, InventoryGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(InventoryGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<InventoryFilter>> FILTERS_FIELD = SdkField
            .<List<InventoryFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(InventoryGroup::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InventoryFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(InventoryFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FILTERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<InventoryFilter> filters;

    private InventoryGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters define the criteria for the group. The <code>matchingCount</code> field displays the number of resources
     * that match the criteria. The <code>notMatchingCount</code> field displays the number of resources that don't
     * match the criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Filters define the criteria for the group. The <code>matchingCount</code> field displays the number of
     *         resources that match the criteria. The <code>notMatchingCount</code> field displays the number of
     *         resources that don't match the criteria.
     */
    public List<InventoryFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryGroup)) {
            return false;
        }
        InventoryGroup other = (InventoryGroup) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InventoryGroup").add("Name", name()).add("Filters", filters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InventoryGroup, T> g) {
        return obj -> g.apply((InventoryGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InventoryGroup> {
        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param name
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Filters define the criteria for the group. The <code>matchingCount</code> field displays the number of
         * resources that match the criteria. The <code>notMatchingCount</code> field displays the number of resources
         * that don't match the criteria.
         * </p>
         * 
         * @param filters
         *        Filters define the criteria for the group. The <code>matchingCount</code> field displays the number of
         *        resources that match the criteria. The <code>notMatchingCount</code> field displays the number of
         *        resources that don't match the criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<InventoryFilter> filters);

        /**
         * <p>
         * Filters define the criteria for the group. The <code>matchingCount</code> field displays the number of
         * resources that match the criteria. The <code>notMatchingCount</code> field displays the number of resources
         * that don't match the criteria.
         * </p>
         * 
         * @param filters
         *        Filters define the criteria for the group. The <code>matchingCount</code> field displays the number of
         *        resources that match the criteria. The <code>notMatchingCount</code> field displays the number of
         *        resources that don't match the criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(InventoryFilter... filters);

        /**
         * <p>
         * Filters define the criteria for the group. The <code>matchingCount</code> field displays the number of
         * resources that match the criteria. The <code>notMatchingCount</code> field displays the number of resources
         * that don't match the criteria.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InventoryFilter>.Builder} avoiding the need
         * to create one manually via {@link List<InventoryFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InventoryFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<InventoryFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<InventoryFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<InventoryFilter>)
         */
        Builder filters(Consumer<InventoryFilter.Builder>... filters);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<InventoryFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryGroup model) {
            name(model.name);
            filters(model.filters);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<InventoryFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(InventoryFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<InventoryFilter> filters) {
            this.filters = InventoryFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(InventoryFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<InventoryFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> InventoryFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<InventoryFilter.BuilderImpl> filters) {
            this.filters = InventoryFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public InventoryGroup build() {
            return new InventoryGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
