/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a failed association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedCreateAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<FailedCreateAssociation.Builder, FailedCreateAssociation> {
    private static final SdkField<CreateAssociationBatchRequestEntry> ENTRY_FIELD = SdkField
            .<CreateAssociationBatchRequestEntry> builder(MarshallingType.SDK_POJO).memberName("Entry")
            .getter(getter(FailedCreateAssociation::entry)).setter(setter(Builder::entry))
            .constructor(CreateAssociationBatchRequestEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entry").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(FailedCreateAssociation::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> FAULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Fault")
            .getter(getter(FailedCreateAssociation::faultAsString)).setter(setter(Builder::fault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fault").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_FIELD, MESSAGE_FIELD,
            FAULT_FIELD));

    private static final long serialVersionUID = 1L;

    private final CreateAssociationBatchRequestEntry entry;

    private final String message;

    private final String fault;

    private FailedCreateAssociation(BuilderImpl builder) {
        this.entry = builder.entry;
        this.message = builder.message;
        this.fault = builder.fault;
    }

    /**
     * <p>
     * The association.
     * </p>
     * 
     * @return The association.
     */
    public CreateAssociationBatchRequestEntry entry() {
        return entry;
    }

    /**
     * <p>
     * A description of the failure.
     * </p>
     * 
     * @return A description of the failure.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The source of the failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fault} will return
     * {@link Fault#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #faultAsString}.
     * </p>
     * 
     * @return The source of the failure.
     * @see Fault
     */
    public Fault fault() {
        return Fault.fromValue(fault);
    }

    /**
     * <p>
     * The source of the failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fault} will return
     * {@link Fault#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #faultAsString}.
     * </p>
     * 
     * @return The source of the failure.
     * @see Fault
     */
    public String faultAsString() {
        return fault;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entry());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(faultAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedCreateAssociation)) {
            return false;
        }
        FailedCreateAssociation other = (FailedCreateAssociation) obj;
        return Objects.equals(entry(), other.entry()) && Objects.equals(message(), other.message())
                && Objects.equals(faultAsString(), other.faultAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FailedCreateAssociation").add("Entry", entry()).add("Message", message())
                .add("Fault", faultAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entry":
            return Optional.ofNullable(clazz.cast(entry()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "Fault":
            return Optional.ofNullable(clazz.cast(faultAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailedCreateAssociation, T> g) {
        return obj -> g.apply((FailedCreateAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedCreateAssociation> {
        /**
         * <p>
         * The association.
         * </p>
         * 
         * @param entry
         *        The association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entry(CreateAssociationBatchRequestEntry entry);

        /**
         * <p>
         * The association.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateAssociationBatchRequestEntry.Builder}
         * avoiding the need to create one manually via {@link CreateAssociationBatchRequestEntry#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateAssociationBatchRequestEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #entry(CreateAssociationBatchRequestEntry)}.
         * 
         * @param entry
         *        a consumer that will call methods on {@link CreateAssociationBatchRequestEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entry(CreateAssociationBatchRequestEntry)
         */
        default Builder entry(Consumer<CreateAssociationBatchRequestEntry.Builder> entry) {
            return entry(CreateAssociationBatchRequestEntry.builder().applyMutation(entry).build());
        }

        /**
         * <p>
         * A description of the failure.
         * </p>
         * 
         * @param message
         *        A description of the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The source of the failure.
         * </p>
         * 
         * @param fault
         *        The source of the failure.
         * @see Fault
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Fault
         */
        Builder fault(String fault);

        /**
         * <p>
         * The source of the failure.
         * </p>
         * 
         * @param fault
         *        The source of the failure.
         * @see Fault
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Fault
         */
        Builder fault(Fault fault);
    }

    static final class BuilderImpl implements Builder {
        private CreateAssociationBatchRequestEntry entry;

        private String message;

        private String fault;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedCreateAssociation model) {
            entry(model.entry);
            message(model.message);
            fault(model.fault);
        }

        public final CreateAssociationBatchRequestEntry.Builder getEntry() {
            return entry != null ? entry.toBuilder() : null;
        }

        @Override
        public final Builder entry(CreateAssociationBatchRequestEntry entry) {
            this.entry = entry;
            return this;
        }

        public final void setEntry(CreateAssociationBatchRequestEntry.BuilderImpl entry) {
            this.entry = entry != null ? entry.build() : null;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getFault() {
            return fault;
        }

        @Override
        public final Builder fault(String fault) {
            this.fault = fault;
            return this;
        }

        @Override
        public final Builder fault(Fault fault) {
            this.fault(fault == null ? null : fault.toString());
            return this;
        }

        public final void setFault(String fault) {
            this.fault = fault;
        }

        @Override
        public FailedCreateAssociation build() {
            return new FailedCreateAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
