/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request body of the ResetServiceSetting API action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResetServiceSettingRequest extends SsmRequest implements
        ToCopyableBuilder<ResetServiceSettingRequest.Builder, ResetServiceSettingRequest> {
    private static final SdkField<String> SETTING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResetServiceSettingRequest::settingId)).setter(setter(Builder::settingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SETTING_ID_FIELD));

    private final String settingId;

    private ResetServiceSettingRequest(BuilderImpl builder) {
        super(builder);
        this.settingId = builder.settingId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service setting to reset. The setting ID can be
     * <code>/ssm/parameter-store/default-parameter-tier</code>,
     * <code>/ssm/parameter-store/high-throughput-enabled</code>, or <code>/ssm/managed-instance/activation-tier</code>.
     * For example,
     * <code>arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service setting to reset. The setting ID can be
     *         <code>/ssm/parameter-store/default-parameter-tier</code>,
     *         <code>/ssm/parameter-store/high-throughput-enabled</code>, or
     *         <code>/ssm/managed-instance/activation-tier</code>. For example,
     *         <code>arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled</code>
     *         .
     */
    public String settingId() {
        return settingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(settingId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetServiceSettingRequest)) {
            return false;
        }
        ResetServiceSettingRequest other = (ResetServiceSettingRequest) obj;
        return Objects.equals(settingId(), other.settingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResetServiceSettingRequest").add("SettingId", settingId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SettingId":
            return Optional.ofNullable(clazz.cast(settingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResetServiceSettingRequest, T> g) {
        return obj -> g.apply((ResetServiceSettingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, ResetServiceSettingRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service setting to reset. The setting ID can be
         * <code>/ssm/parameter-store/default-parameter-tier</code>,
         * <code>/ssm/parameter-store/high-throughput-enabled</code>, or
         * <code>/ssm/managed-instance/activation-tier</code>. For example,
         * <code>arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled</code>.
         * </p>
         * 
         * @param settingId
         *        The Amazon Resource Name (ARN) of the service setting to reset. The setting ID can be
         *        <code>/ssm/parameter-store/default-parameter-tier</code>,
         *        <code>/ssm/parameter-store/high-throughput-enabled</code>, or
         *        <code>/ssm/managed-instance/activation-tier</code>. For example,
         *        <code>arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settingId(String settingId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String settingId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetServiceSettingRequest model) {
            super(model);
            settingId(model.settingId);
        }

        public final String getSettingId() {
            return settingId;
        }

        @Override
        public final Builder settingId(String settingId) {
            this.settingId = settingId;
            return this;
        }

        public final void setSettingId(String settingId) {
            this.settingId = settingId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResetServiceSettingRequest build() {
            return new ResetServiceSettingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
