/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The AWS Organizations organizational unit data source for the sync.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceDataSyncOrganizationalUnit implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceDataSyncOrganizationalUnit.Builder, ResourceDataSyncOrganizationalUnit> {
    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceDataSyncOrganizationalUnit::organizationalUnitId))
            .setter(setter(Builder::organizationalUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATIONAL_UNIT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String organizationalUnitId;

    private ResourceDataSyncOrganizationalUnit(BuilderImpl builder) {
        this.organizationalUnitId = builder.organizationalUnitId;
    }

    /**
     * <p>
     * The AWS Organization unit ID data source for the sync.
     * </p>
     * 
     * @return The AWS Organization unit ID data source for the sync.
     */
    public String organizationalUnitId() {
        return organizationalUnitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDataSyncOrganizationalUnit)) {
            return false;
        }
        ResourceDataSyncOrganizationalUnit other = (ResourceDataSyncOrganizationalUnit) obj;
        return Objects.equals(organizationalUnitId(), other.organizationalUnitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceDataSyncOrganizationalUnit").add("OrganizationalUnitId", organizationalUnitId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationalUnitId":
            return Optional.ofNullable(clazz.cast(organizationalUnitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDataSyncOrganizationalUnit, T> g) {
        return obj -> g.apply((ResourceDataSyncOrganizationalUnit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceDataSyncOrganizationalUnit> {
        /**
         * <p>
         * The AWS Organization unit ID data source for the sync.
         * </p>
         * 
         * @param organizationalUnitId
         *        The AWS Organization unit ID data source for the sync.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitId(String organizationalUnitId);
    }

    static final class BuilderImpl implements Builder {
        private String organizationalUnitId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDataSyncOrganizationalUnit model) {
            organizationalUnitId(model.organizationalUnitId);
        }

        public final String getOrganizationalUnitId() {
            return organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public ResourceDataSyncOrganizationalUnit build() {
            return new ResourceDataSyncOrganizationalUnit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
