/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowFilter;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowFilterListCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMaintenanceWindowExecutionTaskInvocationsRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowExecutionTaskInvocationsRequest> {
    private static final SdkField<String> WINDOW_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeMaintenanceWindowExecutionTaskInvocationsRequest.getter(DescribeMaintenanceWindowExecutionTaskInvocationsRequest::windowExecutionId)).setter(DescribeMaintenanceWindowExecutionTaskInvocationsRequest.setter(Builder::windowExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowExecutionId").build()}).build();
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeMaintenanceWindowExecutionTaskInvocationsRequest.getter(DescribeMaintenanceWindowExecutionTaskInvocationsRequest::taskId)).setter(DescribeMaintenanceWindowExecutionTaskInvocationsRequest.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()}).build();
    private static final SdkField<List<MaintenanceWindowFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeMaintenanceWindowExecutionTaskInvocationsRequest.getter(DescribeMaintenanceWindowExecutionTaskInvocationsRequest::filters)).setter(DescribeMaintenanceWindowExecutionTaskInvocationsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MaintenanceWindowFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeMaintenanceWindowExecutionTaskInvocationsRequest.getter(DescribeMaintenanceWindowExecutionTaskInvocationsRequest::maxResults)).setter(DescribeMaintenanceWindowExecutionTaskInvocationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeMaintenanceWindowExecutionTaskInvocationsRequest.getter(DescribeMaintenanceWindowExecutionTaskInvocationsRequest::nextToken)).setter(DescribeMaintenanceWindowExecutionTaskInvocationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_EXECUTION_ID_FIELD, TASK_ID_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String windowExecutionId;
    private final String taskId;
    private final List<MaintenanceWindowFilter> filters;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeMaintenanceWindowExecutionTaskInvocationsRequest(BuilderImpl builder) {
        super(builder);
        this.windowExecutionId = builder.windowExecutionId;
        this.taskId = builder.taskId;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public String windowExecutionId() {
        return this.windowExecutionId;
    }

    public String taskId() {
        return this.taskId;
    }

    public boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public List<MaintenanceWindowFilter> filters() {
        return this.filters;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.windowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowExecutionTaskInvocationsRequest)) {
            return false;
        }
        DescribeMaintenanceWindowExecutionTaskInvocationsRequest other = (DescribeMaintenanceWindowExecutionTaskInvocationsRequest)((Object)obj);
        return Objects.equals(this.windowExecutionId(), other.windowExecutionId()) && Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeMaintenanceWindowExecutionTaskInvocationsRequest").add("WindowExecutionId", (Object)this.windowExecutionId()).add("TaskId", (Object)this.taskId()).add("Filters", this.filters()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowExecutionId": {
                return Optional.ofNullable(clazz.cast(this.windowExecutionId()));
            }
            case "TaskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMaintenanceWindowExecutionTaskInvocationsRequest, T> g) {
        return obj -> g.apply((DescribeMaintenanceWindowExecutionTaskInvocationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String windowExecutionId;
        private String taskId;
        private List<MaintenanceWindowFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowExecutionTaskInvocationsRequest model) {
            super(model);
            this.windowExecutionId(model.windowExecutionId);
            this.taskId(model.taskId);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getWindowExecutionId() {
            return this.windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final Collection<MaintenanceWindowFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(MaintenanceWindowFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<MaintenanceWindowFilter> filters) {
            this.filters = MaintenanceWindowFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(MaintenanceWindowFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<MaintenanceWindowFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (MaintenanceWindowFilter)((MaintenanceWindowFilter.Builder)MaintenanceWindowFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<MaintenanceWindowFilter.BuilderImpl> filters) {
            this.filters = MaintenanceWindowFilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeMaintenanceWindowExecutionTaskInvocationsRequest build() {
            return new DescribeMaintenanceWindowExecutionTaskInvocationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMaintenanceWindowExecutionTaskInvocationsRequest> {
        public Builder windowExecutionId(String var1);

        public Builder taskId(String var1);

        public Builder filters(Collection<MaintenanceWindowFilter> var1);

        public Builder filters(MaintenanceWindowFilter ... var1);

        public Builder filters(Consumer<MaintenanceWindowFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

