/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AutomationType {
    CROSS_ACCOUNT("CrossAccount"),
    LOCAL("Local"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AutomationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutomationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AutomationType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutomationType> knownValues() {
        return Stream.of(AutomationType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

