/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResourceDataSyncRequest extends SsmRequest implements
        ToCopyableBuilder<UpdateResourceDataSyncRequest.Builder, UpdateResourceDataSyncRequest> {
    private static final SdkField<String> SYNC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateResourceDataSyncRequest::syncName)).setter(setter(Builder::syncName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncName").build()).build();

    private static final SdkField<String> SYNC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateResourceDataSyncRequest::syncType)).setter(setter(Builder::syncType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncType").build()).build();

    private static final SdkField<ResourceDataSyncSource> SYNC_SOURCE_FIELD = SdkField
            .<ResourceDataSyncSource> builder(MarshallingType.SDK_POJO).getter(getter(UpdateResourceDataSyncRequest::syncSource))
            .setter(setter(Builder::syncSource)).constructor(ResourceDataSyncSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNC_NAME_FIELD,
            SYNC_TYPE_FIELD, SYNC_SOURCE_FIELD));

    private final String syncName;

    private final String syncType;

    private final ResourceDataSyncSource syncSource;

    private UpdateResourceDataSyncRequest(BuilderImpl builder) {
        super(builder);
        this.syncName = builder.syncName;
        this.syncType = builder.syncType;
        this.syncSource = builder.syncSource;
    }

    /**
     * <p>
     * The name of the resource data sync you want to update.
     * </p>
     * 
     * @return The name of the resource data sync you want to update.
     */
    public String syncName() {
        return syncName;
    }

    /**
     * <p>
     * The type of resource data sync. If <code>SyncType</code> is <code>SyncToDestination</code>, then the resource
     * data sync synchronizes data to an Amazon S3 bucket. If the <code>SyncType</code> is <code>SyncFromSource</code>
     * then the resource data sync synchronizes data from AWS Organizations or from multiple AWS Regions.
     * </p>
     * 
     * @return The type of resource data sync. If <code>SyncType</code> is <code>SyncToDestination</code>, then the
     *         resource data sync synchronizes data to an Amazon S3 bucket. If the <code>SyncType</code> is
     *         <code>SyncFromSource</code> then the resource data sync synchronizes data from AWS Organizations or from
     *         multiple AWS Regions.
     */
    public String syncType() {
        return syncType;
    }

    /**
     * <p>
     * Specify information about the data sources to synchronize.
     * </p>
     * 
     * @return Specify information about the data sources to synchronize.
     */
    public ResourceDataSyncSource syncSource() {
        return syncSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(syncName());
        hashCode = 31 * hashCode + Objects.hashCode(syncType());
        hashCode = 31 * hashCode + Objects.hashCode(syncSource());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceDataSyncRequest)) {
            return false;
        }
        UpdateResourceDataSyncRequest other = (UpdateResourceDataSyncRequest) obj;
        return Objects.equals(syncName(), other.syncName()) && Objects.equals(syncType(), other.syncType())
                && Objects.equals(syncSource(), other.syncSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateResourceDataSyncRequest").add("SyncName", syncName()).add("SyncType", syncType())
                .add("SyncSource", syncSource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SyncName":
            return Optional.ofNullable(clazz.cast(syncName()));
        case "SyncType":
            return Optional.ofNullable(clazz.cast(syncType()));
        case "SyncSource":
            return Optional.ofNullable(clazz.cast(syncSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceDataSyncRequest, T> g) {
        return obj -> g.apply((UpdateResourceDataSyncRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateResourceDataSyncRequest> {
        /**
         * <p>
         * The name of the resource data sync you want to update.
         * </p>
         * 
         * @param syncName
         *        The name of the resource data sync you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncName(String syncName);

        /**
         * <p>
         * The type of resource data sync. If <code>SyncType</code> is <code>SyncToDestination</code>, then the resource
         * data sync synchronizes data to an Amazon S3 bucket. If the <code>SyncType</code> is
         * <code>SyncFromSource</code> then the resource data sync synchronizes data from AWS Organizations or from
         * multiple AWS Regions.
         * </p>
         * 
         * @param syncType
         *        The type of resource data sync. If <code>SyncType</code> is <code>SyncToDestination</code>, then the
         *        resource data sync synchronizes data to an Amazon S3 bucket. If the <code>SyncType</code> is
         *        <code>SyncFromSource</code> then the resource data sync synchronizes data from AWS Organizations or
         *        from multiple AWS Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncType(String syncType);

        /**
         * <p>
         * Specify information about the data sources to synchronize.
         * </p>
         * 
         * @param syncSource
         *        Specify information about the data sources to synchronize.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncSource(ResourceDataSyncSource syncSource);

        /**
         * <p>
         * Specify information about the data sources to synchronize.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceDataSyncSource.Builder} avoiding the
         * need to create one manually via {@link ResourceDataSyncSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceDataSyncSource.Builder#build()} is called immediately and
         * its result is passed to {@link #syncSource(ResourceDataSyncSource)}.
         * 
         * @param syncSource
         *        a consumer that will call methods on {@link ResourceDataSyncSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syncSource(ResourceDataSyncSource)
         */
        default Builder syncSource(Consumer<ResourceDataSyncSource.Builder> syncSource) {
            return syncSource(ResourceDataSyncSource.builder().applyMutation(syncSource).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String syncName;

        private String syncType;

        private ResourceDataSyncSource syncSource;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceDataSyncRequest model) {
            super(model);
            syncName(model.syncName);
            syncType(model.syncType);
            syncSource(model.syncSource);
        }

        public final String getSyncName() {
            return syncName;
        }

        @Override
        public final Builder syncName(String syncName) {
            this.syncName = syncName;
            return this;
        }

        public final void setSyncName(String syncName) {
            this.syncName = syncName;
        }

        public final String getSyncType() {
            return syncType;
        }

        @Override
        public final Builder syncType(String syncType) {
            this.syncType = syncType;
            return this;
        }

        public final void setSyncType(String syncType) {
            this.syncType = syncType;
        }

        public final ResourceDataSyncSource.Builder getSyncSource() {
            return syncSource != null ? syncSource.toBuilder() : null;
        }

        @Override
        public final Builder syncSource(ResourceDataSyncSource syncSource) {
            this.syncSource = syncSource;
            return this;
        }

        public final void setSyncSource(ResourceDataSyncSource.BuilderImpl syncSource) {
            this.syncSource = syncSource != null ? syncSource.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResourceDataSyncRequest build() {
            return new UpdateResourceDataSyncRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
