/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelParameterVersionResponse extends SsmResponse implements
        ToCopyableBuilder<LabelParameterVersionResponse.Builder, LabelParameterVersionResponse> {
    private static final SdkField<List<String>> INVALID_LABELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(LabelParameterVersionResponse::invalidLabels))
            .setter(setter(Builder::invalidLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidLabels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALID_LABELS_FIELD));

    private final List<String> invalidLabels;

    private LabelParameterVersionResponse(BuilderImpl builder) {
        super(builder);
        this.invalidLabels = builder.invalidLabels;
    }

    /**
     * <p>
     * The label does not meet the requirements. For information about parameter label requirements, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html">Labeling
     * Parameters</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The label does not meet the requirements. For information about parameter label requirements, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html">Labeling
     *         Parameters</a> in the <i>AWS Systems Manager User Guide</i>.
     */
    public List<String> invalidLabels() {
        return invalidLabels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invalidLabels());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelParameterVersionResponse)) {
            return false;
        }
        LabelParameterVersionResponse other = (LabelParameterVersionResponse) obj;
        return Objects.equals(invalidLabels(), other.invalidLabels());
    }

    @Override
    public String toString() {
        return ToString.builder("LabelParameterVersionResponse").add("InvalidLabels", invalidLabels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvalidLabels":
            return Optional.ofNullable(clazz.cast(invalidLabels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelParameterVersionResponse, T> g) {
        return obj -> g.apply((LabelParameterVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, LabelParameterVersionResponse> {
        /**
         * <p>
         * The label does not meet the requirements. For information about parameter label requirements, see <a
         * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html">Labeling
         * Parameters</a> in the <i>AWS Systems Manager User Guide</i>.
         * </p>
         * 
         * @param invalidLabels
         *        The label does not meet the requirements. For information about parameter label requirements, see <a
         *        href
         *        ="http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html">Labeling
         *        Parameters</a> in the <i>AWS Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidLabels(Collection<String> invalidLabels);

        /**
         * <p>
         * The label does not meet the requirements. For information about parameter label requirements, see <a
         * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html">Labeling
         * Parameters</a> in the <i>AWS Systems Manager User Guide</i>.
         * </p>
         * 
         * @param invalidLabels
         *        The label does not meet the requirements. For information about parameter label requirements, see <a
         *        href
         *        ="http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html">Labeling
         *        Parameters</a> in the <i>AWS Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidLabels(String... invalidLabels);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<String> invalidLabels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LabelParameterVersionResponse model) {
            super(model);
            invalidLabels(model.invalidLabels);
        }

        public final Collection<String> getInvalidLabels() {
            return invalidLabels;
        }

        @Override
        public final Builder invalidLabels(Collection<String> invalidLabels) {
            this.invalidLabels = ParameterLabelListCopier.copy(invalidLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidLabels(String... invalidLabels) {
            invalidLabels(Arrays.asList(invalidLabels));
            return this;
        }

        public final void setInvalidLabels(Collection<String> invalidLabels) {
            this.invalidLabels = ParameterLabelListCopier.copy(invalidLabels);
        }

        @Override
        public LabelParameterVersionResponse build() {
            return new LabelParameterVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
