/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateActivationResponse extends SsmResponse implements
        ToCopyableBuilder<CreateActivationResponse.Builder, CreateActivationResponse> {
    private static final SdkField<String> ACTIVATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateActivationResponse::activationId)).setter(setter(Builder::activationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationId").build()).build();

    private static final SdkField<String> ACTIVATION_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateActivationResponse::activationCode)).setter(setter(Builder::activationCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_ID_FIELD,
            ACTIVATION_CODE_FIELD));

    private final String activationId;

    private final String activationCode;

    private CreateActivationResponse(BuilderImpl builder) {
        super(builder);
        this.activationId = builder.activationId;
        this.activationCode = builder.activationCode;
    }

    /**
     * <p>
     * The ID number generated by the system when it processed the activation. The activation ID functions like a user
     * name.
     * </p>
     * 
     * @return The ID number generated by the system when it processed the activation. The activation ID functions like
     *         a user name.
     */
    public String activationId() {
        return activationId;
    }

    /**
     * <p>
     * The code the system generates when it processes the activation. The activation code functions like a password to
     * validate the activation ID.
     * </p>
     * 
     * @return The code the system generates when it processes the activation. The activation code functions like a
     *         password to validate the activation ID.
     */
    public String activationCode() {
        return activationCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activationId());
        hashCode = 31 * hashCode + Objects.hashCode(activationCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateActivationResponse)) {
            return false;
        }
        CreateActivationResponse other = (CreateActivationResponse) obj;
        return Objects.equals(activationId(), other.activationId()) && Objects.equals(activationCode(), other.activationCode());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateActivationResponse").add("ActivationId", activationId())
                .add("ActivationCode", activationCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivationId":
            return Optional.ofNullable(clazz.cast(activationId()));
        case "ActivationCode":
            return Optional.ofNullable(clazz.cast(activationCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateActivationResponse, T> g) {
        return obj -> g.apply((CreateActivationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateActivationResponse> {
        /**
         * <p>
         * The ID number generated by the system when it processed the activation. The activation ID functions like a
         * user name.
         * </p>
         * 
         * @param activationId
         *        The ID number generated by the system when it processed the activation. The activation ID functions
         *        like a user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationId(String activationId);

        /**
         * <p>
         * The code the system generates when it processes the activation. The activation code functions like a password
         * to validate the activation ID.
         * </p>
         * 
         * @param activationCode
         *        The code the system generates when it processes the activation. The activation code functions like a
         *        password to validate the activation ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationCode(String activationCode);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String activationId;

        private String activationCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateActivationResponse model) {
            super(model);
            activationId(model.activationId);
            activationCode(model.activationCode);
        }

        public final String getActivationId() {
            return activationId;
        }

        @Override
        public final Builder activationId(String activationId) {
            this.activationId = activationId;
            return this;
        }

        public final void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        public final String getActivationCode() {
            return activationCode;
        }

        @Override
        public final Builder activationCode(String activationCode) {
            this.activationCode = activationCode;
            return this;
        }

        public final void setActivationCode(String activationCode) {
            this.activationCode = activationCode;
        }

        @Override
        public CreateActivationResponse build() {
            return new CreateActivationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
