/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.NonCompliantSummary;
import software.amazon.awssdk.services.ssm.transform.SeveritySummaryUnmarshaller;

public class NonCompliantSummaryUnmarshaller
implements Unmarshaller<NonCompliantSummary, JsonUnmarshallerContext> {
    private static final NonCompliantSummaryUnmarshaller INSTANCE = new NonCompliantSummaryUnmarshaller();

    public NonCompliantSummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        NonCompliantSummary.Builder nonCompliantSummaryBuilder = NonCompliantSummary.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("NonCompliantCount", targetDepth)) {
                    context.nextToken();
                    nonCompliantSummaryBuilder.nonCompliantCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("SeveritySummary", targetDepth)) {
                    context.nextToken();
                    nonCompliantSummaryBuilder.severitySummary(SeveritySummaryUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (NonCompliantSummary)nonCompliantSummaryBuilder.build();
    }

    public static NonCompliantSummaryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

