/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.nio.ByteBuffer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowLambdaParameters;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MaintenanceWindowLambdaParametersMarshaller {
    private static final MarshallingInfo<String> CLIENTCONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientContext").isBinary(false).build();
    private static final MarshallingInfo<String> QUALIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Qualifier").isBinary(false).build();
    private static final MarshallingInfo<ByteBuffer> PAYLOAD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Payload").isBinary(false).build();
    private static final MaintenanceWindowLambdaParametersMarshaller INSTANCE = new MaintenanceWindowLambdaParametersMarshaller();

    private MaintenanceWindowLambdaParametersMarshaller() {
    }

    public static MaintenanceWindowLambdaParametersMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MaintenanceWindowLambdaParameters maintenanceWindowLambdaParameters, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)maintenanceWindowLambdaParameters, (String)"maintenanceWindowLambdaParameters");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)maintenanceWindowLambdaParameters.clientContext(), CLIENTCONTEXT_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowLambdaParameters.qualifier(), QUALIFIER_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowLambdaParameters.payload(), PAYLOAD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

