/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListComplianceItemsRequestModelMarshaller {
    private static final MarshallingInfo<List> FILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Filters").isBinary(false).build();
    private static final MarshallingInfo<List> RESOURCEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceIds").isBinary(false).build();
    private static final MarshallingInfo<List> RESOURCETYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceTypes").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final ListComplianceItemsRequestModelMarshaller INSTANCE = new ListComplianceItemsRequestModelMarshaller();

    private ListComplianceItemsRequestModelMarshaller() {
    }

    public static ListComplianceItemsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListComplianceItemsRequest listComplianceItemsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listComplianceItemsRequest), (String)"listComplianceItemsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(listComplianceItemsRequest.filters(), FILTERS_BINDING);
            protocolMarshaller.marshall(listComplianceItemsRequest.resourceIds(), RESOURCEIDS_BINDING);
            protocolMarshaller.marshall(listComplianceItemsRequest.resourceTypes(), RESOURCETYPES_BINDING);
            protocolMarshaller.marshall((Object)listComplianceItemsRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)listComplianceItemsRequest.maxResults(), MAXRESULTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

