/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceAssociationStatusInfoMarshaller {
    private static final MarshallingInfo<String> ASSOCIATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").isBinary(false).build();
    private static final MarshallingInfo<String> ASSOCIATIONVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationVersion").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final MarshallingInfo<Instant> EXECUTIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionDate").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> DETAILEDSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DetailedStatus").isBinary(false).build();
    private static final MarshallingInfo<String> EXECUTIONSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionSummary").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputUrl").isBinary(false).build();
    private static final MarshallingInfo<String> ASSOCIATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationName").isBinary(false).build();
    private static final InstanceAssociationStatusInfoMarshaller INSTANCE = new InstanceAssociationStatusInfoMarshaller();

    private InstanceAssociationStatusInfoMarshaller() {
    }

    public static InstanceAssociationStatusInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceAssociationStatusInfo instanceAssociationStatusInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceAssociationStatusInfo, (String)"instanceAssociationStatusInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceAssociationStatusInfo.associationId(), ASSOCIATIONID_BINDING);
            protocolMarshaller.marshall((Object)instanceAssociationStatusInfo.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)instanceAssociationStatusInfo.documentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall((Object)instanceAssociationStatusInfo.associationVersion(), ASSOCIATIONVERSION_BINDING);
            protocolMarshaller.marshall((Object)instanceAssociationStatusInfo.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)instanceAssociationStatusInfo.executionDate(), EXECUTIONDATE_BINDING);
            protocolMarshaller.marshall((Object)instanceAssociationStatusInfo.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)instanceAssociationStatusInfo.detailedStatus(), DETAILEDSTATUS_BINDING);
            protocolMarshaller.marshall((Object)instanceAssociationStatusInfo.executionSummary(), EXECUTIONSUMMARY_BINDING);
            protocolMarshaller.marshall((Object)instanceAssociationStatusInfo.errorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)instanceAssociationStatusInfo.outputUrl(), OUTPUTURL_BINDING);
            protocolMarshaller.marshall((Object)instanceAssociationStatusInfo.associationName(), ASSOCIATIONNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

