/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.DocumentIdentifier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DocumentIdentifierMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Owner").isBinary(false).build();
    private static final MarshallingInfo<List> PLATFORMTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformTypes").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentType").isBinary(false).build();
    private static final MarshallingInfo<String> SCHEMAVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaVersion").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final DocumentIdentifierMarshaller INSTANCE = new DocumentIdentifierMarshaller();

    private DocumentIdentifierMarshaller() {
    }

    public static DocumentIdentifierMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DocumentIdentifier documentIdentifier, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)documentIdentifier, (String)"documentIdentifier");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)documentIdentifier.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)documentIdentifier.owner(), OWNER_BINDING);
            protocolMarshaller.marshall(documentIdentifier.platformTypesStrings(), PLATFORMTYPES_BINDING);
            protocolMarshaller.marshall((Object)documentIdentifier.documentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall((Object)documentIdentifier.documentTypeString(), DOCUMENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)documentIdentifier.schemaVersion(), SCHEMAVERSION_BINDING);
            protocolMarshaller.marshall(documentIdentifier.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

