/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.ComplianceItem;
import software.amazon.awssdk.services.ssm.transform.ComplianceExecutionSummaryUnmarshaller;

public class ComplianceItemUnmarshaller
implements Unmarshaller<ComplianceItem, JsonUnmarshallerContext> {
    private static final ComplianceItemUnmarshaller INSTANCE = new ComplianceItemUnmarshaller();

    public ComplianceItem unmarshall(JsonUnmarshallerContext context) throws Exception {
        ComplianceItem.Builder complianceItemBuilder = ComplianceItem.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ComplianceType", targetDepth)) {
                    context.nextToken();
                    complianceItemBuilder.complianceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResourceType", targetDepth)) {
                    context.nextToken();
                    complianceItemBuilder.resourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResourceId", targetDepth)) {
                    context.nextToken();
                    complianceItemBuilder.resourceId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    complianceItemBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Title", targetDepth)) {
                    context.nextToken();
                    complianceItemBuilder.title((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    complianceItemBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Severity", targetDepth)) {
                    context.nextToken();
                    complianceItemBuilder.severity((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ExecutionSummary", targetDepth)) {
                    context.nextToken();
                    complianceItemBuilder.executionSummary(ComplianceExecutionSummaryUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Details", targetDepth)) {
                    context.nextToken();
                    complianceItemBuilder.details(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ComplianceItem)complianceItemBuilder.build();
    }

    public static ComplianceItemUnmarshaller getInstance() {
        return INSTANCE;
    }
}

