/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.AssociationDescription;
import software.amazon.awssdk.services.ssm.transform.AssociationOverviewUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.AssociationStatusUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.InstanceAssociationOutputLocationUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.TargetUnmarshaller;

public class AssociationDescriptionUnmarshaller
implements Unmarshaller<AssociationDescription, JsonUnmarshallerContext> {
    private static final AssociationDescriptionUnmarshaller INSTANCE = new AssociationDescriptionUnmarshaller();

    public AssociationDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        AssociationDescription.Builder associationDescriptionBuilder = AssociationDescription.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    associationDescriptionBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InstanceId", targetDepth)) {
                    context.nextToken();
                    associationDescriptionBuilder.instanceId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AssociationVersion", targetDepth)) {
                    context.nextToken();
                    associationDescriptionBuilder.associationVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Date", targetDepth)) {
                    context.nextToken();
                    associationDescriptionBuilder.date((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastUpdateAssociationDate", targetDepth)) {
                    context.nextToken();
                    associationDescriptionBuilder.lastUpdateAssociationDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    associationDescriptionBuilder.status(AssociationStatusUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Overview", targetDepth)) {
                    context.nextToken();
                    associationDescriptionBuilder.overview(AssociationOverviewUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DocumentVersion", targetDepth)) {
                    context.nextToken();
                    associationDescriptionBuilder.documentVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    context.nextToken();
                    associationDescriptionBuilder.parameters(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)new ListUnmarshaller(context.getUnmarshaller(String.class))).unmarshall(context));
                }
                if (context.testExpression("AssociationId", targetDepth)) {
                    context.nextToken();
                    associationDescriptionBuilder.associationId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Targets", targetDepth)) {
                    context.nextToken();
                    associationDescriptionBuilder.targets(new ListUnmarshaller((Unmarshaller)TargetUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ScheduleExpression", targetDepth)) {
                    context.nextToken();
                    associationDescriptionBuilder.scheduleExpression((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("OutputLocation", targetDepth)) {
                    context.nextToken();
                    associationDescriptionBuilder.outputLocation(InstanceAssociationOutputLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LastExecutionDate", targetDepth)) {
                    context.nextToken();
                    associationDescriptionBuilder.lastExecutionDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastSuccessfulExecutionDate", targetDepth)) {
                    context.nextToken();
                    associationDescriptionBuilder.lastSuccessfulExecutionDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("AssociationName", targetDepth)) {
                    context.nextToken();
                    associationDescriptionBuilder.associationName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AssociationDescription)associationDescriptionBuilder.build();
    }

    public static AssociationDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

