/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.Activation;

public class ActivationUnmarshaller
implements Unmarshaller<Activation, JsonUnmarshallerContext> {
    private static final ActivationUnmarshaller INSTANCE = new ActivationUnmarshaller();

    public Activation unmarshall(JsonUnmarshallerContext context) throws Exception {
        Activation.Builder activationBuilder = Activation.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ActivationId", targetDepth)) {
                    context.nextToken();
                    activationBuilder.activationId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    activationBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DefaultInstanceName", targetDepth)) {
                    context.nextToken();
                    activationBuilder.defaultInstanceName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("IamRole", targetDepth)) {
                    context.nextToken();
                    activationBuilder.iamRole((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RegistrationLimit", targetDepth)) {
                    context.nextToken();
                    activationBuilder.registrationLimit((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("RegistrationsCount", targetDepth)) {
                    context.nextToken();
                    activationBuilder.registrationsCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("ExpirationDate", targetDepth)) {
                    context.nextToken();
                    activationBuilder.expirationDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Expired", targetDepth)) {
                    context.nextToken();
                    activationBuilder.expired((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreatedDate", targetDepth)) {
                    context.nextToken();
                    activationBuilder.createdDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Activation)activationBuilder.build();
    }

    public static ActivationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

