/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.ssm.SSMAsyncClient;
import software.amazon.awssdk.services.ssm.model.DocumentIdentifier;
import software.amazon.awssdk.services.ssm.model.ListDocumentsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentsResponse;

public class ListDocumentsPublisher
implements SdkPublisher<ListDocumentsResponse> {
    private final SSMAsyncClient client;
    private final ListDocumentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDocumentsPublisher(SSMAsyncClient client, ListDocumentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDocumentsPublisher(SSMAsyncClient client, ListDocumentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDocumentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDocumentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<DocumentIdentifier> documentIdentifiers() {
        Function<ListDocumentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.documentIdentifiers() != null) {
                return response.documentIdentifiers().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListDocumentsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListDocumentsPublisher resume(ListDocumentsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListDocumentsPublisher(this.client, (ListDocumentsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListDocumentsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListDocumentsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListDocumentsResponseFetcher
    implements AsyncPageFetcher<ListDocumentsResponse> {
        private ListDocumentsResponseFetcher() {
        }

        public boolean hasNextPage(ListDocumentsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListDocumentsResponse> nextPage(ListDocumentsResponse previousPage) {
            if (previousPage == null) {
                return ListDocumentsPublisher.this.client.listDocuments(ListDocumentsPublisher.this.firstRequest);
            }
            return ListDocumentsPublisher.this.client.listDocuments((ListDocumentsRequest)((Object)ListDocumentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

