/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.ssm.SSMClient;
import software.amazon.awssdk.services.ssm.model.DocumentIdentifier;
import software.amazon.awssdk.services.ssm.model.ListDocumentsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentsResponse;

public class ListDocumentsIterable
implements SdkIterable<ListDocumentsResponse> {
    private final SSMClient client;
    private final ListDocumentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDocumentsIterable(SSMClient client, ListDocumentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDocumentsResponseFetcher();
    }

    public Iterator<ListDocumentsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<DocumentIdentifier> documentIdentifiers() {
        Function<ListDocumentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.documentIdentifiers() != null) {
                return response.documentIdentifiers().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListDocumentsIterable resume(ListDocumentsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListDocumentsIterable(this.client, (ListDocumentsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListDocumentsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListDocumentsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListDocumentsResponseFetcher
    implements SyncPageFetcher<ListDocumentsResponse> {
        private ListDocumentsResponseFetcher() {
        }

        public boolean hasNextPage(ListDocumentsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListDocumentsResponse nextPage(ListDocumentsResponse previousPage) {
            if (previousPage == null) {
                return ListDocumentsIterable.this.client.listDocuments(ListDocumentsIterable.this.firstRequest);
            }
            return ListDocumentsIterable.this.client.listDocuments((ListDocumentsRequest)((Object)ListDocumentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

