/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.ssm.SSMClient;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse;

public class GetParameterHistoryIterable
implements SdkIterable<GetParameterHistoryResponse> {
    private final SSMClient client;
    private final GetParameterHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetParameterHistoryIterable(SSMClient client, GetParameterHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetParameterHistoryResponseFetcher();
    }

    public Iterator<GetParameterHistoryResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetParameterHistoryIterable resume(GetParameterHistoryResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetParameterHistoryIterable(this.client, (GetParameterHistoryRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetParameterHistoryIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetParameterHistoryResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetParameterHistoryResponseFetcher
    implements SyncPageFetcher<GetParameterHistoryResponse> {
        private GetParameterHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetParameterHistoryResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetParameterHistoryResponse nextPage(GetParameterHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetParameterHistoryIterable.this.client.getParameterHistory(GetParameterHistoryIterable.this.firstRequest);
            }
            return GetParameterHistoryIterable.this.client.getParameterHistory((GetParameterHistoryRequest)((Object)GetParameterHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

