/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.S3OutputUrlMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3OutputUrl
implements StructuredPojo,
ToCopyableBuilder<Builder, S3OutputUrl> {
    private final String outputUrl;

    private S3OutputUrl(BuilderImpl builder) {
        this.outputUrl = builder.outputUrl;
    }

    public String outputUrl() {
        return this.outputUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3OutputUrl)) {
            return false;
        }
        S3OutputUrl other = (S3OutputUrl)obj;
        return Objects.equals(this.outputUrl(), other.outputUrl());
    }

    public String toString() {
        return ToString.builder((String)"S3OutputUrl").add("OutputUrl", (Object)this.outputUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputUrl": {
                return Optional.of(clazz.cast(this.outputUrl()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3OutputUrlMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(S3OutputUrl model) {
            this.outputUrl(model.outputUrl);
        }

        public final String getOutputUrl() {
            return this.outputUrl;
        }

        @Override
        public final Builder outputUrl(String outputUrl) {
            this.outputUrl = outputUrl;
            return this;
        }

        public final void setOutputUrl(String outputUrl) {
            this.outputUrl = outputUrl;
        }

        public S3OutputUrl build() {
            return new S3OutputUrl(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3OutputUrl> {
        public Builder outputUrl(String var1);
    }
}

