/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncItem;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncItemListCopier;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListResourceDataSyncResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, ListResourceDataSyncResponse> {
    private final List<ResourceDataSyncItem> resourceDataSyncItems;
    private final String nextToken;

    private ListResourceDataSyncResponse(BuilderImpl builder) {
        super(builder);
        this.resourceDataSyncItems = builder.resourceDataSyncItems;
        this.nextToken = builder.nextToken;
    }

    public List<ResourceDataSyncItem> resourceDataSyncItems() {
        return this.resourceDataSyncItems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDataSyncItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceDataSyncResponse)) {
            return false;
        }
        ListResourceDataSyncResponse other = (ListResourceDataSyncResponse)((Object)obj);
        return Objects.equals(this.resourceDataSyncItems(), other.resourceDataSyncItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListResourceDataSyncResponse").add("ResourceDataSyncItems", this.resourceDataSyncItems()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceDataSyncItems": {
                return Optional.of(clazz.cast(this.resourceDataSyncItems()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private List<ResourceDataSyncItem> resourceDataSyncItems;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceDataSyncResponse model) {
            this.resourceDataSyncItems(model.resourceDataSyncItems);
            this.nextToken(model.nextToken);
        }

        public final Collection<ResourceDataSyncItem.Builder> getResourceDataSyncItems() {
            return this.resourceDataSyncItems != null ? (Collection)this.resourceDataSyncItems.stream().map(ResourceDataSyncItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceDataSyncItems(Collection<ResourceDataSyncItem> resourceDataSyncItems) {
            this.resourceDataSyncItems = ResourceDataSyncItemListCopier.copy(resourceDataSyncItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDataSyncItems(ResourceDataSyncItem ... resourceDataSyncItems) {
            this.resourceDataSyncItems(Arrays.asList(resourceDataSyncItems));
            return this;
        }

        public final void setResourceDataSyncItems(Collection<ResourceDataSyncItem.BuilderImpl> resourceDataSyncItems) {
            this.resourceDataSyncItems = ResourceDataSyncItemListCopier.copyFromBuilder(resourceDataSyncItems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListResourceDataSyncResponse build() {
            return new ListResourceDataSyncResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, ListResourceDataSyncResponse> {
        public Builder resourceDataSyncItems(Collection<ResourceDataSyncItem> var1);

        public Builder resourceDataSyncItems(ResourceDataSyncItem ... var1);

        public Builder nextToken(String var1);
    }
}

