/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInventorySchemaRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, GetInventorySchemaRequest> {
    private final String typeName;
    private final String nextToken;
    private final Integer maxResults;
    private final Boolean aggregator;
    private final Boolean subType;

    private GetInventorySchemaRequest(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.aggregator = builder.aggregator;
        this.subType = builder.subType;
    }

    public String typeName() {
        return this.typeName;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Boolean aggregator() {
        return this.aggregator;
    }

    public Boolean subType() {
        return this.subType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregator());
        hashCode = 31 * hashCode + Objects.hashCode(this.subType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInventorySchemaRequest)) {
            return false;
        }
        GetInventorySchemaRequest other = (GetInventorySchemaRequest)((Object)obj);
        return Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.aggregator(), other.aggregator()) && Objects.equals(this.subType(), other.subType());
    }

    public String toString() {
        return ToString.builder((String)"GetInventorySchemaRequest").add("TypeName", (Object)this.typeName()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Aggregator", (Object)this.aggregator()).add("SubType", (Object)this.subType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeName": {
                return Optional.of(clazz.cast(this.typeName()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "Aggregator": {
                return Optional.of(clazz.cast(this.aggregator()));
            }
            case "SubType": {
                return Optional.of(clazz.cast(this.subType()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private String typeName;
        private String nextToken;
        private Integer maxResults;
        private Boolean aggregator;
        private Boolean subType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInventorySchemaRequest model) {
            this.typeName(model.typeName);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.aggregator(model.aggregator);
            this.subType(model.subType);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Boolean getAggregator() {
            return this.aggregator;
        }

        @Override
        public final Builder aggregator(Boolean aggregator) {
            this.aggregator = aggregator;
            return this;
        }

        public final void setAggregator(Boolean aggregator) {
            this.aggregator = aggregator;
        }

        public final Boolean getSubType() {
            return this.subType;
        }

        @Override
        public final Builder subType(Boolean subType) {
            this.subType = subType;
            return this;
        }

        public final void setSubType(Boolean subType) {
            this.subType = subType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetInventorySchemaRequest build() {
            return new GetInventorySchemaRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, GetInventorySchemaRequest> {
        public Builder typeName(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder aggregator(Boolean var1);

        public Builder subType(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

