/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDeployablePatchSnapshotForInstanceRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, GetDeployablePatchSnapshotForInstanceRequest> {
    private final String instanceId;
    private final String snapshotId;

    private GetDeployablePatchSnapshotForInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.snapshotId = builder.snapshotId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeployablePatchSnapshotForInstanceRequest)) {
            return false;
        }
        GetDeployablePatchSnapshotForInstanceRequest other = (GetDeployablePatchSnapshotForInstanceRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.snapshotId(), other.snapshotId());
    }

    public String toString() {
        return ToString.builder((String)"GetDeployablePatchSnapshotForInstanceRequest").add("InstanceId", (Object)this.instanceId()).add("SnapshotId", (Object)this.snapshotId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "SnapshotId": {
                return Optional.of(clazz.cast(this.snapshotId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeployablePatchSnapshotForInstanceRequest model) {
            this.instanceId(model.instanceId);
            this.snapshotId(model.snapshotId);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetDeployablePatchSnapshotForInstanceRequest build() {
            return new GetDeployablePatchSnapshotForInstanceRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, GetDeployablePatchSnapshotForInstanceRequest> {
        public Builder instanceId(String var1);

        public Builder snapshotId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

